package io.intino.monet.messaging.pushnotifications;

import io.intino.monet.messaging.emails.util.JsonPretty;
import io.intino.monet.messaging.logging.MessagingLog;

import java.util.*;

public interface PushNotificationServicePipeline {

    default boolean onBeforeSend(PushNotification notification) {return true;}

    default void onAfterSend(PushNotification notification, SendResult sendResult) {}

    default void onError(Throwable e) {
        MessagingLog.error(e);
    }

    default void onBackendNotFound(PushNotification notification) {
        MessagingLog.warn("Push notification backend not found for " + notification.recipient());
    }

    class Default implements PushNotificationServicePipeline { }

    class SendResult {

        public final String backendName;
        public final List<SendResponse> responses = new LinkedList<>();

        public SendResult(String backendName) {
            this.backendName = backendName;
        }

        public boolean isSuccessful() {
            return failureCount() == 0;
        }

        public int successCount() {
            return (int) responses.stream().filter(r -> r.error == null).count();
        }

        public int failureCount() {
            return responses.size() - successCount();
        }

        @Override
        public String toString() {
            return JsonPretty.toJson(this);
        }
    }

    class SendResponse {

        public final Map<String, String> info = new HashMap<>();
        public final Exception error;

        public SendResponse(Exception error) {
            this.error = error;
        }

        @Override
        public String toString() {
            return JsonPretty.toJson(this);
        }
    }
}
