package io.intino.monet.messaging.emails;

import io.intino.alexandria.Json;
import io.intino.monet.messaging.Recipient;

import java.io.File;
import java.time.Instant;
import java.util.*;

public class Email {

    private final EmailSignature signature;
    private String subject;
    private final Body body = new Body();
    private final Recipients recipients = new Recipients();
    private final Map<String, String> properties = new LinkedHashMap<>();
    private Instant ts = Instant.now();

    public Email(EmailSignature signature) {
        this.signature = signature;
    }

    public EmailSignature signature() {
        return signature;
    }

    public String subject() {
        return subject;
    }

    public Email subject(String subject) {
        this.subject = subject;
        return this;
    }

    public Body body() {
        return body;
    }

    public Recipients recipients() {
        return recipients;
    }

    public Map<String, String> properties() {
        return properties;
    }

    public Email putProperty(String key, String value) {
        properties.put(key, value);
        return this;
    }

    public Instant ts() {
        return ts;
    }

    public Email ts(Instant ts) {
        this.ts = ts;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Email email = (Email) o;
        return Objects.equals(subject, email.subject) && Objects.equals(body, email.body) && Objects.equals(recipients, email.recipients);
    }

    @Override
    public int hashCode() {
        return Objects.hash(subject, body, recipients);
    }

    @Override
    public String toString() {
        return Json.toString(this);
    }

    public class Recipients {

        private Recipient to;
        private List<Recipient> cc = new LinkedList<>();
        private List<Recipient> bcc = new LinkedList<>();

        public Recipient to() {
            return to;
        }

        public Email to(Recipient to) {
            this.to = to;
            return Email.this;
        }

        public List<Recipient> cc() {
            return cc;
        }

        public Email cc(List<Recipient> cc) {
            this.cc = cc;
            return Email.this;
        }

        public List<Recipient> bcc() {
            return bcc;
        }

        public Email bcc(List<Recipient> bcc) {
            this.bcc = bcc;
            return Email.this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            Recipients that = (Recipients) o;
            return Objects.equals(to, that.to) && Objects.equals(cc, that.cc) && Objects.equals(bcc, that.bcc);
        }

        @Override
        public int hashCode() {
            return Objects.hash(to, cc, bcc);
        }

        @Override
        public String toString() {
            return "Recipients{" +
                    "to=" + to +
                    ", cc=" + cc +
                    ", bcc=" + bcc +
                    '}';
        }
    }

    public class Body {

        private String text = "";
        private List<File> attachments = new LinkedList<>();
        private String contentType = "text/html;charset=utf-8";

        public String text() {
            return text;
        }

        public Email text(String text) {
            this.text = text;
            return Email.this;
        }

        public List<File> attachments() {
            return attachments;
        }

        public Email attachments(List<File> attachments) {
            this.attachments = attachments;
            return Email.this;
        }

        public String contentType() {
            return contentType;
        }

        public Email contentType(String contentType) {
            this.contentType = contentType;
            return Email.this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            Body body = (Body) o;
            return Objects.equals(text, body.text) && Objects.equals(attachments, body.attachments) && Objects.equals(contentType, body.contentType);
        }

        @Override
        public int hashCode() {
            return Objects.hash(text, attachments, contentType);
        }

        @Override
        public String toString() {
            return "Body{" +
                    "text='" + text + '\'' +
                    ", attachments=" + attachments +
                    ", contentType='" + contentType + '\'' +
                    '}';
        }
    }
}
