package io.intino.monet.messaging;

import io.intino.monet.messaging.emails.util.JsonPretty;

import java.io.Serializable;
import java.util.Objects;

public class Recipient {

    private final String email;
    private Device device = new Device();

    public Recipient(String email) {
        this.email = email;
    }

    public String email() {
        return email;
    }

    public Device device() {
        if(device == null) device = new Device();
        return device;
    }

    public Recipient device(Device device) {
        this.device = device == null ? new Device() : device;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Recipient recipient = (Recipient) o;
        return Objects.equals(email, recipient.email);
    }

    @Override
    public int hashCode() {
        return Objects.hash(email);
    }

    @Override
    public String toString() {
        return JsonPretty.toJson(this);
    }

    public static class Device implements Serializable {

        private String token;
        private String brand;
        private String model;
        private String os;
        private boolean googleServices = true; // Assume google services are available by default

        public String token() {
            return token;
        }

        public Device token(String token) {
            this.token = token;
            return this;
        }

        public String brand() {
            return brand;
        }

        public Device brand(String brand) {
            this.brand = brand;
            return this;
        }

        public String model() {
            return model;
        }

        public Device model(String model) {
            this.model = model;
            return this;
        }

        public String os() {
            return os;
        }

        public Device os(String so) {
            this.os = so;
            return this;
        }

        public boolean googleServices() {
            return googleServices;
        }

        public Device googleServices(boolean googleServices) {
            this.googleServices = googleServices;
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            Device device = (Device) o;
            return Objects.equals(token, device.token);
        }

        @Override
        public int hashCode() {
            return Objects.hash(token);
        }

        @Override
        public String toString() {
            return JsonPretty.toJson(this);
        }
    }
}
