package io.intino.monet.messaging;

import io.intino.monet.messaging.senders.EmailSender;
import io.intino.monet.messaging.senders.PushSender;

import static io.intino.monet.messaging.Notification.Channel.Email;
import static io.intino.monet.messaging.Notification.Channel.Push;
import static java.util.Objects.requireNonNull;

public class NotificationHandler {

    private final Messaging messaging;

    public NotificationHandler(Messaging messaging) {
        this.messaging = requireNonNull(messaging);
    }

    public void handle(Notification notification) {
        if(notification.channel() == Email)
            new EmailSender(messaging).send(notification);
        else if(notification.channel() == Push)
            new PushSender(messaging).send(notification);
    }
}
