package io.intino.monet.messaging;

import io.intino.monet.messaging.emails.util.JsonPretty;

import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;

public class Notification {

    private String id;
    private String type;
    private Channel channel;
    private String language;
    private Recipient recipient;
    private final Map<String, String> properties = new LinkedHashMap<>();
    private final Map<String, Attachment> attachments = new LinkedHashMap<>();
    private Instant ts;

    public enum Channel {
        Email, Push
    }

    public String id() {
        return id;
    }

    public Notification id(String id) {
        this.id = id;
        return this;
    }

    public String type() {
        return type;
    }

    public Notification type(String type) {
        this.type = type;
        return this;
    }

    public Channel channel() {
        return channel;
    }

    public Notification channel(Channel channel) {
        this.channel = channel;
        return this;
    }

    public String language() {
        return language;
    }

    public Notification language(String language) {
        this.language = language;
        return this;
    }

    public Recipient recipient() {
        return recipient;
    }

    public Notification recipient(Recipient recipient) {
        this.recipient = recipient;
        return this;
    }

    public Map<String, String> properties() {
        return properties;
    }

    public Notification addProperty(String name, String value) {
        properties.put(name, value);
        return this;
    }

    public Map<String, Attachment> attachments() {
        return attachments;
    }

    public Notification addAttachment(String name, Attachment attachment) {
        attachments.put(name, attachment);
        return this;
    }

    public Instant ts() {
        return ts;
    }

    public Notification ts(Instant ts) {
        this.ts = ts;
        return this;
    }

    @Override
    public String toString() {
        return JsonPretty.toJson(this);
    }

    public static class Attachment {

        public final Type type;
        public final String value;

        public Attachment(Type type, String value) {
            this.type = type;
            this.value = value;
        }

        public enum Type {
            Text, File
        }
    }
}
