package io.intino.monet.messaging;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MessageBlacklist {

    private final Set<String> disabledMessageTypes;

    public MessageBlacklist() {
        this.disabledMessageTypes = new HashSet<>();
    }

    public void enable(String type) {
        disabledMessageTypes.remove(type);
    }

    public void disable(String type) {
        disabledMessageTypes.add(type);
    }

    public boolean isEnabled(String type) {
        return !isDisabled(type);
    }

    public boolean isDisabled(String type) {
        return disabledMessageTypes.contains(type);
    }

    public List<String> getDisabledMessageTypes() {
        return new ArrayList<>(disabledMessageTypes);
    }
}
