/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.engine;

import io.intino.alexandria.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OrderTypes {
    private static final Map<String, Record> records = new HashMap<String, Record>();
    private static final Map<String, BiConsumer<Record, String>> setters = new HashMap<String, BiConsumer<Record, String>>(){
        {
            this.put("label.en", (r, v) -> {
                r.labelEn = v;
            });
            this.put("label.es", (r, v) -> {
                r.labelEs = v;
            });
            this.put("label.pt", (r, v) -> {
                r.labelPt = v;
            });
            this.put("hint.en", (r, v) -> {
                r.hintEn = v;
            });
            this.put("hint.es", (r, v) -> {
                r.hintEs = v;
            });
            this.put("hint.pt", (r, v) -> {
                r.hintPt = v;
            });
            this.put("code", (r, v) -> {
                r.code = v;
            });
            this.put("effort", (r, v) -> {
                r.effort = Integer.parseInt(v);
            });
            this.put("input", (r, v) -> {
                r.input = v;
            });
            this.put("calculations", (r, v) -> {
                r.calculations = v;
            });
            this.put("annexes", (r, v) -> {
                r.annexes = v;
            });
            this.put("target", (r, v) -> {
                r.target = v;
            });
            this.put("channel", (r, v) -> {
                r.channel = Channel.valueOf(v);
            });
            this.put("assertion", (r, v) -> {
                String[] split = v.split(":");
                r.assertionCode = split[0];
                r.assertionAttr = split.length == 1 ? Collections.emptyMap() : (Map)Arrays.stream(split[1].split(",")).map(s -> s.split(" as ")).collect(Collectors.toMap(s -> s[0].trim(), s -> ((String[])s).length == 1 ? s[0].trim() : s[1].trim(), (v1, v2) -> v1, LinkedHashMap::new));
            });
        }
    };

    public static void init(File file) {
        try {
            records.clear();
            if (!file.exists()) {
                return;
            }
            Files.readAllLines(file.toPath()).stream().filter(l -> !l.trim().isEmpty()).map(l -> l.split("\t", -1)).forEach(l -> setters.getOrDefault(l[1], OrderTypes.nullSetter()).accept(OrderTypes.record(l[0]), l[2]));
            OrderTypes.all().forEach(r -> OrderTypes.load(file, r));
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private static void load(File file, Record record) {
        File orderTypeFile = new File(file.getParentFile(), "order-types/" + record.code + ".triples");
        Map<String, List<String[]>> triples = Checklist.triples(orderTypeFile);
        record.checklist = Checklist.load(orderTypeFile);
        record.triples = record.checklist.fields.stream().sorted(Comparator.comparing(e -> e.code)).collect(Collectors.toMap(e -> e, e -> Checklist.asMap(Checklist.triples(triples.getOrDefault(e.code, Collections.emptyList()))), (a, v) -> a, LinkedHashMap::new));
    }

    private static BiConsumer<Record, String> nullSetter() {
        return (record, s) -> {};
    }

    public static Collection<Record> all() {
        return records.values();
    }

    public static Record of(String code) {
        return records.get(code);
    }

    private static Record record(String id) {
        if (!records.containsKey(id)) {
            Record record = new Record();
            record.code = id;
            records.put(id, record);
        }
        return records.get(id);
    }

    private static List<String> listOf(String value) {
        if (value == null) {
            return Collections.emptyList();
        }
        return Stream.of(value.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    public static class Checklist
    implements Iterable<Field> {
        private final List<Field> fields = new ArrayList<Field>();

        private static Checklist load(File file) {
            return Checklist.load(Checklist.triples(file));
        }

        private static Checklist load(Map<String, List<String[]>> triples) {
            Checklist checklist = new Checklist();
            for (String key : triples.keySet()) {
                checklist.add(key, Checklist.triples(triples.get(key)));
            }
            Checklist.sort(checklist.fields);
            checklist.setSections();
            return checklist;
        }

        private static void sort(List<Field> fields) {
            fields.sort(Comparator.comparing(f -> f.code));
        }

        private static List<Entry> triples(List<String[]> splits) {
            return splits.stream().map(Entry::new).collect(Collectors.toList());
        }

        private static Map<String, String> asMap(List<Entry> entries) {
            HashMap<String, String> map = new HashMap<String, String>(entries.size());
            for (Entry entry : entries) {
                map.put(entry.key, entry.value);
            }
            return map;
        }

        private static Map<String, List<String[]>> triples(File file) {
            try {
                return Files.readAllLines(file.toPath()).stream().filter(s -> !s.isEmpty()).map(s -> s.split("\t")).collect(Collectors.groupingBy(s -> s[0]));
            }
            catch (IOException ignored) {
                return Collections.emptyMap();
            }
        }

        private void setSections() {
            Field section = null;
            for (Field field : this.fields) {
                if (field.type == Type.Section) {
                    section = field;
                    continue;
                }
                if (section == null) continue;
                field.section(section);
            }
        }

        public Field field(String key) {
            return this.fields.stream().filter(f -> f.code.equalsIgnoreCase(key) || f.name.equalsIgnoreCase(key)).findFirst().orElse(null);
        }

        public List<Field> fields() {
            return this.fields;
        }

        private void add(String code, List<Entry> entries) {
            this.add(new Field(code, Checklist.asMap(entries)));
        }

        private void add(Field field) {
            this.fields.add(field);
        }

        @Override
        public Iterator<Field> iterator() {
            return this.fields.iterator();
        }

        public static class Entry {
            public final String key;
            public final String value;

            public Entry(String[] split) {
                this(split[1], split[2]);
            }

            public Entry(String key, String value) {
                this.key = key;
                this.value = value;
            }
        }

        public static class Field {
            public final String name;
            public final Type type;
            private final String code;
            private final boolean optional;
            private final String conditional;
            private final List<String> filter;
            private final Map<String, String> entries;
            private Field section;

            public Field(String code, Map<String, String> entries) {
                this.code = code;
                this.name = entries.get("name");
                this.type = Type.valueOf(entries.getOrDefault("type", "String"));
                this.entries = entries;
                this.optional = Boolean.parseBoolean(entries.getOrDefault("optional", "false"));
                this.filter = OrderTypes.listOf(entries.getOrDefault("filter", ""));
                this.conditional = entries.get("conditional");
            }

            public String title(String language) {
                return this.get("title.", language);
            }

            public String description(String language) {
                return this.get("description.", language);
            }

            public List<String> values(String language) {
                return Stream.of(this.get("values.", language).split(";")).map(String::trim).collect(Collectors.toList());
            }

            public Double valueMin() {
                return this.entries.containsKey("value-min") ? Double.valueOf(Double.parseDouble(this.entries.get("value-min"))) : null;
            }

            public Double valueMax() {
                return this.entries.containsKey("value-max") ? Double.valueOf(Double.parseDouble(this.entries.get("value-max"))) : null;
            }

            public Double valueDefault() {
                return this.entries.containsKey("value-default") ? Double.parseDouble(this.entries.get("value-default")) : 0.0;
            }

            public String unit() {
                return this.entries.get("unit");
            }

            public boolean isOptional() {
                return this.optional;
            }

            public boolean isConditional() {
                return this.conditional != null;
            }

            public String conditional() {
                return this.conditional;
            }

            public List<String> filter() {
                return this.filter;
            }

            public Field section() {
                return this.section;
            }

            public String get(String attribute, String language) {
                return this.entries.getOrDefault(attribute + language, "");
            }

            public String toString() {
                return "Field{type=" + this.type + ", name='" + this.name + "'}";
            }

            private void section(Field section) {
                this.section = section;
            }
        }

        public static enum Type {
            String,
            Number,
            Date,
            Option,
            MultiOption,
            Image,
            Entity,
            Package,
            Note,
            Marker,
            Section,
            Signature,
            Validation;

        }
    }

    public static class Record {
        private String code;
        private String labelEn;
        private String labelEs;
        private String labelPt;
        private String hintEn;
        private String hintEs;
        private String hintPt;
        private String target;
        private int effort;
        private String input;
        private String calculations;
        private String annexes;
        private Channel channel;
        private Checklist checklist = new Checklist();
        private Map<Checklist.Field, Map<String, String>> triples = new HashMap<Checklist.Field, Map<String, String>>();
        private String assertionCode;
        private Map<String, String> assertionAttr;

        public String code() {
            return this.code;
        }

        public String label(String lang) {
            return lang.equals("en") ? this.labelEn : (lang.equals("es") ? this.labelEs : this.labelPt);
        }

        public String hint(String lang) {
            return lang.equals("en") ? this.hintEn : (lang.equals("es") ? this.hintEs : this.hintPt);
        }

        public String category() {
            return this.code.startsWith("P") ? "Preventive" : (this.code.startsWith("A") ? "Administrative" : "Corrective");
        }

        public int effort() {
            return this.effort;
        }

        public boolean isManual() {
            return this.input == null || this.input.isEmpty();
        }

        public List<String> input() {
            if (this.input == null) {
                return Collections.emptyList();
            }
            return Stream.of(this.input.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        }

        public List<String> calculations() {
            if (this.calculations == null) {
                return Collections.emptyList();
            }
            return Stream.of(this.calculations.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        }

        public List<String> annexes() {
            if (this.annexes == null) {
                return Collections.emptyList();
            }
            return Stream.of(this.annexes.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        }

        public String target() {
            return this.target;
        }

        public Channel channel() {
            return this.channel;
        }

        public String assertionCode() {
            return this.assertionCode;
        }

        public Map<String, String> assertionAttrs() {
            return this.assertionAttr;
        }

        public Checklist checklist() {
            return this.checklist;
        }

        public Map<Checklist.Field, Map<String, String>> triples() {
            return this.triples;
        }
    }

    public static enum Channel {
        web,
        app,
        both;

    }
}

