/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.engine.edition.editors;

import io.intino.alexandria.logger.Logger;
import io.intino.monet.engine.edition.Edition;
import io.intino.monet.engine.edition.FormStore;
import io.intino.monet.engine.edition.Language;
import io.intino.monet.engine.edition.editors.util.DynamicSourceHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class OptionMultipleEdition
extends Edition {
    private final File thesaurusRepository;
    private final String optionsSource;
    private final Set<String> dependentFields;
    protected List<String> options;

    public OptionMultipleEdition(String name, FormStore store, Map<String, String> options, Language language) {
        super(name, store, options, language);
        this.thesaurusRepository = new File(options.get("thesaurus-repository"));
        this.optionsSource = options.get("values." + language);
        this.dependentFields = DynamicSourceHelper.getVariables(this.optionsSource);
    }

    @Override
    protected void onModified(String name) {
        if (this.isStaticSource()) {
            return;
        }
        if (this.dependentFields().contains(name)) {
            this.set("");
        }
    }

    @Override
    public Edition init() {
        super.init();
        if (this.isStaticSource() && this.options == null) {
            this.options = this.loadOptions();
        }
        return this;
    }

    private List<String> loadOptions() {
        if (this.isStaticSource()) {
            return this.toList(this.optionsSource);
        }
        String filename = this.sourceFilename();
        return filename != null ? this.optionsFromFile(filename) : Collections.emptyList();
    }

    private boolean isStaticSource() {
        return !this.optionsSource.startsWith("@");
    }

    private List<String> optionsFromFile(String filename) {
        try {
            File thesaurus = new File(this.thesaurusRepository + "/" + filename);
            return thesaurus.exists() ? Files.readAllLines(thesaurus.toPath()) : Collections.emptyList();
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return Collections.emptyList();
        }
    }

    private String sourceFilename() {
        return DynamicSourceHelper.getDynamicRoute(this.optionsSource).map(this::storeValueOf).collect(Collectors.joining(""));
    }

    private Set<String> dependentFields() {
        return this.dependentFields;
    }

    public List<String> options() {
        return this.options == null ? this.loadOptions() : this.options;
    }

    public String[] get() {
        String value = (String)this.value();
        return value == null || value.isEmpty() ? new String[]{} : value.split(";");
    }

    public void set(String ... values) {
        this.store.put(this.name, String.join((CharSequence)";", values));
    }

    private List<String> toList(String values) {
        if (values == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(values.split(";")).map(String::trim).collect(Collectors.toList());
    }
}

