/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.engine.edition.editors;

import io.intino.monet.engine.edition.Edition;
import io.intino.monet.engine.edition.FormStore;
import io.intino.monet.engine.edition.Language;
import java.time.LocalDate;
import java.util.Map;

public class DateEdition
extends Edition {
    private final Mode mode;

    public DateEdition(String name, FormStore store, Map<String, String> options, Language language) {
        super(name, store, options, language);
        this.mode = Mode.valueOf(options.getOrDefault("value-type", "Any"));
    }

    public Mode mode() {
        return this.mode;
    }

    public LocalDate get() {
        return (LocalDate)this.value();
    }

    @Override
    public Object value() {
        Object value = super.value();
        if (value instanceof String && !this.isEmpty(value)) {
            return LocalDate.parse((String)value);
        }
        return value;
    }

    public void set(LocalDate value) {
        this.store.put(this.name, value);
    }

    private void setDefault() {
        if (this.store.get(this.name) != null) {
            return;
        }
        this.store.put(this.name, LocalDate.now());
    }

    public static enum Mode {
        Any,
        Past,
        Future;

    }
}

