package io.intino.monet.engine.edition.editors;

import io.intino.monet.engine.edition.Edition;
import io.intino.monet.engine.edition.FormStore;
import io.intino.monet.engine.edition.Language;

import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import static java.util.Collections.emptyList;

public class 	PackageEdition extends Edition {

	public PackageEdition(String name, FormStore store, Map<String, String> options, Language language) {
		super(name, store, options, language);
	}

	public Package get() {
		return new Package();
	}

	public void set() {
		store.put(name, "");
	}

	public class Package {

		public void add(File file) {
			store.put(name + "/" + file.getName(), file);
		}

		public void add(String name, InputStream is) {
			store.put(PackageEdition.this.name + "/" + name, is);
		}

		public List<File> files() {
			File[] files = listFiles();
			return files != null ? Arrays.asList(files) : emptyList();
		}

		private File[] listFiles() {
			File file = fileOf(store.get(name));
			return file != null ? file.listFiles() : new File[0];
		}

		private File fileOf(Object o) {
			return o instanceof Object[] ? fileOf((Object[]) o) : null;
		}

		private File fileOf(Object[] array) {
			return (File) array[1];
		}

	}

}
