package io.intino.monet.engine.edition.editors;

import io.intino.monet.engine.edition.Edition;
import io.intino.monet.engine.edition.FormStore;
import io.intino.monet.engine.edition.Language;

import java.io.File;
import java.util.Map;

public class ImageEdition extends Edition {

	public ImageEdition(String name, FormStore store, Map<String, String> options, Language language) {
		super(name, store, options, language);
	}

	public Image get() {
		Object o = store.get(name);
		return (o instanceof Object[]) ? new Image((Object[]) o) : null;
	}

	public void set(Image image) {
		set(image.file, image.label);
	}

	public void set(File file) {
		set(file, "");
	}

	public void set(File file, String label) {
		store.put(name, file);
		store.put(name, label != null ? label : "");
	}

	public static class Image {
		public final File file;
		public final String label;

		public Image(File file, String label) {
			this.file = file;
			this.label = label;
		}

		public Image(Object[] o) {
			this.file = o.length > 1 ? (File) o[1] : null;
			this.label = o.length > 0 ? String.valueOf(o[0]) : null;
		}
	}
}
