package io.intino.monet.engine.edition.editors;

import io.intino.monet.engine.edition.Edition;
import io.intino.monet.engine.edition.FormStore;
import io.intino.monet.engine.edition.Language;

import java.time.LocalDate;
import java.util.Map;

public class DateEdition extends Edition {
	private final Mode mode;

	public DateEdition(String name, FormStore store, Map<String, String> options, Language language) {
		super(name, store, options, language);
		this.mode = Mode.valueOf(options.getOrDefault("value-type","Any"));
		//this.setDefault();
	}

	public Mode mode() {
		return mode;
	}

	public LocalDate get() {
		return (LocalDate) value();
	}

	@Override
	public Object value() {
		Object value = super.value();
		if (value instanceof String && !isEmpty(value)) return LocalDate.parse((String)value);
		return value;
	}

	public void set(LocalDate value) {
		store.put(name, value);
	}

	private void setDefault() {
		if (store.get(name) != null) return;
		store.put(name, LocalDate.now());
	}

	public enum Mode {
		Any,Past,Future;
	}
}
