package io.intino.monet.engine.edition.editors;

import io.intino.monet.engine.edition.FormStore;
import io.intino.monet.engine.edition.Language;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ValidationEdition extends OptionEdition {

	public ValidationEdition(String name, FormStore store, Map<String, String> options, Language language) {
		super(name, store, options, language);
		this.options = translationMap.getOrDefault(language, translationMap.get(Language.en));
	}

	@Override
	protected boolean isDynamicSource() {
		return false;
	}

	@Override
	protected List<String> loadOptions() {
		return options;
	}

	private static final Map<Language, List<String>> translationMap = new HashMap<>() {{
		put(Language.es, List.of("Correcto", "Incorrecto"));
		put(Language.en, List.of("Correct", "Incorrect"));
		put(Language.pt, List.of("Correto", "Errado"));
	}};

}
