package io.intino.monet.engine.edition.editors;

import io.intino.monet.engine.edition.*;

import java.util.Map;

public class SectionEdition extends Edition {
	private final Section section;

	public SectionEdition(String name, FormStore store, Map<String, String> options, Section section, Language language) {
		super(name, store, options, language);
		this.section = section;
	}

	public boolean get() {
		return value() == null;
	}

	@Override
	public void skip() {
		super.skip();
		sweep(FormStore.hidden);
	}

	@Override
	public void enable() {
		super.enable();
		sweep(null);
	}

	@Override
	public void disable() {
		super.disable();
		sweep(FormStore.hidden);
	}

	public void set() {
		this.store.put(name, "");
		sweep(null);
	}

	private void sweep(Object value) {
		for (FieldDefinition definition : section)
			store.put(definition.name, value != null ? value : store.get(definition.name));
	}

}
