package io.intino.monet.engine.edition;

import java.util.Iterator;
import java.util.List;

import static java.util.Collections.emptyIterator;

public class Section implements Iterable<FieldDefinition> {
	private final List<FieldDefinition> definitions;
	private final Language language;

	public Section(List<FieldDefinition> definitions, Language language) {
		this.definitions = definitions;
		this.language = language;
	}

	public String title() {
		return definitions.size() == 0 ? "" : definitions.get(0).get("title." + language);
	}

	@Override
	public Iterator<FieldDefinition> iterator() {
		if (definitions.size() == 0) return emptyIterator();
		return definitions.subList(1,definitions.size()).iterator();
	}
}
