package io.intino.monet.engine.edition;

import java.util.Map;

public class FieldDefinition {
	public final String id;
	public final String name;
	public final FieldType type;
	public final Map<String, String> options;

	public FieldDefinition(String id, Map<String, String> predicates) {
		this.id = id;
		this.name = predicates.get("name");
		this.type = FieldType.valueOf(predicates.get("type"));
		this.options = predicates;
	}

	public String get(String option) {
		return options.getOrDefault(option, "");
	}
}
