package io.intino.monet.engine;

import io.intino.alexandria.Resource;

import java.time.Instant;
import java.util.List;
import java.util.Map;

public class WorkReport {
	private Order order;
	private String author;
	private String area;
	private Map<String, String> attributes;
	private List<Resource> images;
	private String language;
	private String comments;
	private Instant finished;

	public Order order() {
		return order;
	}

	public WorkReport order(Order order) {
		this.order = order;
		return this;
	}

	public String author() {
		return author;
	}

	public WorkReport author(String author) {
		this.author = author;
		return this;
	}

	public String area() {
		return area;
	}

	public WorkReport area(String area) {
		this.area = area;
		return this;
	}

	public Map<String, String> attributes() {
		return attributes;
	}

	public WorkReport attributes(Map<String, String> attributes) {
		this.attributes = attributes;
		return this;
	}

	public List<Resource> images() {
		return images;
	}

	public WorkReport images(List<Resource> images) {
		this.images = images;
		return this;
	}

	public String language() {
		return language;
	}

	public WorkReport language(String language) {
		this.language = language;
		return this;
	}

	public String comments() {
		return comments;
	}

	public WorkReport comments(String comments) {
		this.comments = comments;
		return this;
	}

	public Instant finished() {
		return finished;
	}

	public WorkReport finished(Instant finished) {
		this.finished = finished;
		return this;
	}
}
