package io.intino.monet.engine;

import io.intino.alexandria.Json;

import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Order {
	private final String id;
	private final String code;
	private String input;
	private String properties;
	private Instant createDate;
	private Instant scheduleDate;
	private Instant dueDate;

	public Order(String id, String code) {
		this.id = id;
		this.code = code;
	}

	public String id() {
		return id;
	}

	public String code() {
		return code;
	}

	public String input() {
		return input;
	}

	public Order input(String input) {
		this.input = input;
		return this;
	}

	@SuppressWarnings("unchecked")
	public Map<String, String> inputMap() {
		String input = input();
		if (input == null || input.isEmpty()) return new HashMap<>();
		Map<String, Object> map = Json.fromString(input, Map.class);
		return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> String.valueOf(e.getValue())));
	}

	private static final String Recipients = "recipients";
	private List<String> recipients() {
		String recipients = property(Recipients);
		return recipients != null ? List.of(recipients.split("\\|")) : Collections.emptyList();
	}

	public String properties() {
		return properties;
	}

	public Order properties(String properties) {
		this.properties = properties;
		return this;
	}

	public String property(String name) {
		Map<String, String> properties = propertiesMap();
		return properties.getOrDefault(name, null);
	}

	public void add(String property, String value) {
		Map<String, String> properties = propertiesMap();
		properties.put(property, value);
		this.properties = Json.toString(properties);
	}

	@SuppressWarnings("unchecked")
	public Map<String, String> propertiesMap() {
		String properties = properties();
		if (properties == null || properties.isEmpty()) return new HashMap<>();
		Map<String, Object> map = Json.fromString(properties, Map.class);
		return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> String.valueOf(e.getValue())));
	}

	public Instant createDate() {
		return createDate;
	}

	public Order createDate(Instant createDate) {
		this.createDate = createDate;
		return this;
	}

	public Instant scheduleDate() {
		return scheduleDate;
	}

	public Order scheduleDate(Instant scheduleDate) {
		this.scheduleDate = scheduleDate;
		return this;
	}

	public Instant dueDate() {
		return dueDate;
	}

	public Order dueDate(Instant dueDate) {
		this.dueDate = dueDate;
		return this;
	}

	public boolean isDisabled() {
		return inputMap().containsKey("disabled");
	}

	public boolean isHighlighted() {
		return inputMap().containsKey("highlighted");
	}

	public boolean isStoreDefined() {
		return inputMap().containsKey("store");
	}

	public String store() {
		return inputMap().getOrDefault("store", clean(id));
	}

	private String clean(String id) {
		return id.replace(":", "-").replace("_", "-");
	}

}
