/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.engine.edition;

import io.intino.monet.engine.edition.Edition;
import io.intino.monet.engine.edition.Field;
import io.intino.monet.engine.edition.FieldDefinition;
import io.intino.monet.engine.edition.FieldType;
import io.intino.monet.engine.edition.FormDefinition;
import io.intino.monet.engine.edition.FormStore;
import io.intino.monet.engine.edition.Language;
import io.intino.monet.engine.edition.Section;
import io.intino.monet.engine.edition.editors.DateEdition;
import io.intino.monet.engine.edition.editors.ImageEdition;
import io.intino.monet.engine.edition.editors.NoteEdition;
import io.intino.monet.engine.edition.editors.NumberEdition;
import io.intino.monet.engine.edition.editors.OptionEdition;
import io.intino.monet.engine.edition.editors.OptionMultipleEdition;
import io.intino.monet.engine.edition.editors.PackageEdition;
import io.intino.monet.engine.edition.editors.SectionEdition;
import io.intino.monet.engine.edition.editors.SignatureEdition;
import io.intino.monet.engine.edition.editors.StringEdition;
import io.intino.monet.engine.edition.editors.ValidationEdition;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Form {
    public final FormDefinition definition;
    public final FormStore store;
    private Language language;

    public Form(FormDefinition definition, FormStore store) {
        this.definition = definition;
        this.store = store;
        this.language = Language.es;
    }

    public Field start(Language language) {
        this.language = language;
        return this.field(0);
    }

    public Field field(String name) {
        return this.field(this.indexOf(name));
    }

    public Field field(int index) {
        return this.check(index) ? this.createField(index, this.definition.at(index)) : null;
    }

    public List<Edition> editions(FieldType ... types) {
        return this.editions(Set.of(types));
    }

    private List<Edition> editions(Set<FieldType> types) {
        return this.store.keys().stream().map(this::indexOf).filter(i -> i != -1).sorted().filter(i -> types.isEmpty() || types.contains((Object)this.definition.at((int)i.intValue()).type)).map(this::edition).collect(Collectors.toList());
    }

    public boolean isCompleted() {
        return this.sizeOf(this.store) == this.definition.size();
    }

    public int progress() {
        if (this.definition.size() == 0) {
            return 100;
        }
        return this.sizeOf(this.store) * 100 / this.definition.size();
    }

    private int sizeOf(FormStore store) {
        return (int)this.definition.fields().stream().filter(f -> store.get(f.name) != null).count();
    }

    private boolean check(int index) {
        return 0 <= index && index < this.definition.size();
    }

    private Field createField(final int index, final FieldDefinition definition) {
        return new Field(){

            @Override
            public String name() {
                return definition.name;
            }

            @Override
            public String header() {
                return Form.this.isSection(index) ? "" : Form.this.sectionOf(index).title();
            }

            @Override
            public String title() {
                return definition.get("title." + Form.this.language.name());
            }

            @Override
            public String description() {
                return definition.get("description." + Form.this.language.name());
            }

            @Override
            public FieldDefinition definition() {
                return definition;
            }

            @Override
            public FieldType type() {
                return definition.type;
            }

            @Override
            public Edition edition() {
                return Form.this.edition(index);
            }

            @Override
            public boolean hasNext() {
                return this.nextIndex() < Form.this.definition.size();
            }

            @Override
            public boolean hasPrev() {
                return this.prevIndex() > 0;
            }

            @Override
            public Field next() {
                Field field;
                for (field = Form.this.field(this.nextIndex()); field != null && field.edition().isDisabled(); field = field.next()) {
                }
                return field;
            }

            @Override
            public Field prev() {
                Field field;
                for (field = Form.this.field(this.prevIndex()); field != null && field.edition().isDisabled(); field = field.prev()) {
                }
                return field;
            }

            private int nextIndex() {
                return this.isSectionAndSkippedOrDisabled(index) ? Form.this.nextSection(index + 1) : index + 1;
            }

            private int prevIndex() {
                int result;
                for (result = index - 1; result >= 0 && (this.isHidden(result) || this.isDisabled(result)); --result) {
                }
                if (result < 0) {
                    return 0;
                }
                return result;
            }

            private boolean isSectionAndSkippedOrDisabled(int index2) {
                return Form.this.isSection(index2) && (this.isSkipped(index2) || this.isDisabled(index2));
            }

            private boolean isSkipped(int index2) {
                return this.get(index2) == FormStore.skipped;
            }

            private boolean isHidden(int index2) {
                return this.get(index2) == FormStore.hidden;
            }

            private boolean isDisabled(int index2) {
                return this.get(index2) == FormStore.disabled;
            }

            private Object get(int index2) {
                return Form.this.store.get(Form.this.nameOf(index2));
            }
        };
    }

    private String nameOf(int index) {
        return this.check(index) ? this.definition.at((int)index).name : null;
    }

    private int indexOf(String name) {
        return IntStream.range(0, this.definition.size()).filter(i -> this.definition.at((int)i).name.equals(name)).findFirst().orElse(-1);
    }

    private Edition edition(int index) {
        FieldDefinition definition = this.definition.at(index);
        switch (definition.type) {
            case String: {
                return new StringEdition(definition.name, this.store, definition.options, this.language).init();
            }
            case Date: {
                return new DateEdition(definition.name, this.store, definition.options, this.language).init();
            }
            case Number: {
                return new NumberEdition(definition.name, this.store, definition.options, this.language).init();
            }
            case Image: {
                return new ImageEdition(definition.name, this.store, definition.options, this.language).init();
            }
            case Signature: {
                return new SignatureEdition(definition.name, this.store, definition.options, this.language).init();
            }
            case Note: {
                return new NoteEdition(definition.name, this.store, definition.options, this.language).init();
            }
            case Package: {
                return new PackageEdition(definition.name, this.store, definition.options, this.language).init();
            }
            case Option: {
                return new OptionEdition(definition.name, this.store, definition.options, this.language).init();
            }
            case MultiOption: {
                return new OptionMultipleEdition(definition.name, this.store, definition.options, this.language).init();
            }
            case Marker: 
            case Section: {
                return new SectionEdition(definition.name, this.store, definition.options, this.sectionOf(index), this.language).init();
            }
            case Validation: {
                return new ValidationEdition(definition.name, this.store, definition.options, this.language).init();
            }
        }
        return null;
    }

    private Section sectionOf(int index) {
        return new Section(this.definitionsOfCurrentSection(index), this.language);
    }

    private List<FieldDefinition> definitionsOfCurrentSection(int index) {
        int from = this.previousSection(index);
        return from >= 0 ? this.definitions(from, this.nextSection(index + 1)) : List.of();
    }

    private List<FieldDefinition> definitions(int from, int to) {
        return IntStream.range(from, to).mapToObj(this.definition::at).collect(Collectors.toList());
    }

    private int previousSection(int index) {
        while (index >= 0 && !this.isSection(index)) {
            --index;
        }
        return index;
    }

    private int nextSection(int index) {
        while (index < this.definition.size() && !this.isSection(index)) {
            ++index;
        }
        return index;
    }

    private boolean isSection(int index) {
        return this.definition.at((int)index).type == FieldType.Section || this.definition.at((int)index).type == FieldType.Marker;
    }
}

