/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.engine.edition;

import io.intino.monet.engine.edition.FormStore;
import io.intino.monet.engine.edition.Language;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;

public abstract class Edition {
    protected final String name;
    protected final FormStore store;
    protected final boolean isOptional;
    protected final String conditional;
    protected final File attachment;

    public Edition(String name, FormStore store, Map<String, String> options, Language language) {
        this.name = name;
        this.store = store;
        this.isOptional = this.isTrue(options.get("optional"));
        this.conditional = options.getOrDefault("conditional", null);
        this.attachment = this.attachment(options, language);
    }

    public Edition init() {
        this.checkConditional();
        return this;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public boolean isConditional() {
        return this.conditional != null;
    }

    public File attachment() {
        return this.attachment;
    }

    public void skip() {
        if (!this.isOptional()) {
            throw new EditionException("Can't skip non optional field");
        }
        this.store.put(this.name, FormStore.skipped);
    }

    public void enable() {
        if (this.store.get(this.name) != FormStore.disabled) {
            return;
        }
        this.store.put(this.name, null);
    }

    public void disable() {
        this.store.put(this.name, FormStore.disabled);
    }

    public String name() {
        return this.name;
    }

    public Object value() {
        return this.store.get(this.name);
    }

    public boolean isNull() {
        return this.value() == null;
    }

    public boolean isEmpty() {
        return this.isEmpty(this.value());
    }

    public boolean isSkipped() {
        return Objects.equals(this.value(), FormStore.skipped);
    }

    public boolean isDisabled() {
        return Objects.equals(this.value(), FormStore.disabled);
    }

    public boolean isHidden() {
        return Objects.equals(this.value(), FormStore.hidden);
    }

    public <T extends Edition> T as(Class<T> aClass) {
        return (T)(aClass.isAssignableFrom(aClass) ? this : null);
    }

    private boolean isTrue(String optional) {
        return "true".equalsIgnoreCase(optional);
    }

    protected boolean isEmpty(Object value) {
        return value == null || value instanceof String && ((String)value).length() > 0 && ((String)value).charAt(0) == '\u0018';
    }

    protected String storeValueOf(String name) {
        Object value = this.store.get(name);
        if (value == null) {
            return name;
        }
        String result = null;
        if (value instanceof Object[]) {
            result = this.arrayValueOf((Object[])value);
        } else if (value instanceof String) {
            result = (String)value;
        }
        return result;
    }

    private String arrayValueOf(Object[] value) {
        if (value.length == 0) {
            return null;
        }
        return (String)value[0];
    }

    private void checkConditional() {
        if (!this.isConditional()) {
            return;
        }
        if (this.fulfillCondition()) {
            this.enable();
        } else {
            this.disable();
        }
    }

    private boolean fulfillCondition() {
        String name = this.conditionalName();
        if (name == null) {
            return false;
        }
        String storeValue = this.storeValueOf(name);
        if (storeValue == null) {
            return false;
        }
        String value = this.conditionalValue();
        return value != null && Arrays.asList(value.split("\\|")).contains(storeValue);
    }

    private String conditionalName() {
        if (this.conditional == null) {
            return null;
        }
        return this.conditional.split("=")[0];
    }

    private String conditionalValue() {
        if (this.conditional == null) {
            return null;
        }
        return this.conditional.split("=")[1];
    }

    private File attachment(Map<String, String> options, Language language) {
        String attachment = options.getOrDefault("attachment." + language, null);
        if (attachment == null || attachment.isEmpty()) {
            return null;
        }
        return new File(options.get("attachment-repository") + "/" + attachment);
    }

    public static class EditionException
    extends RuntimeException {
        public EditionException(String message) {
            super(message);
        }
    }
}

