import { createTheme } from '@material-ui/core/styles';

const Theme = (function () {
	var theme = null;
	var provider = {
        defaultMode: () => {
            return "light";
        },
        isAutoMode: () => {
            return "light" == "auto";
        },
		create: (mode) => {
            const primary = mode == "dark" ? "#005b9f" : "#005b9f";
            const secondary = mode == "dark" ? "#ff9100" : "#ff9100";
            const error = mode == "dark" ? "#f44336" : "#f44336";
			theme = createTheme({
				palette : {
					type : mode,
					primary : { main: primary },
					secondary : { main: secondary },
					error : { main: error },
					contrastThreshold : "3",
					tonalOffset : "0.2",
					grey : {
						primary: "#888",
						secondary: '#ddd'
					}
				},
				typography : {
					fontFamily : '"-apple-system","BlinkMacSystemFont","Segoe UI","Roboto","Helvetica Neue","Arial","sans-serif","Apple Color Emoji","Segoe UI Emoji","Segoe UI Symbol"',
					fontSize : 11,
					useNextVariants: true
				},
				darkFormats: {

				},
				formats: {
					h1: { textShadow:'2px 2px 2px #fff',fontSize:'20pt' },
					h2: { textShadow:'2px 2px 2px #fff',fontSize:'18pt' },
					h3: { fontSize:'15pt' },
					h4: { fontSize:'14pt',fontWeight:'400' },
					h5: { fontSize:'12pt' },
					h6: { lineHeight:'17pt',fontSize:'12pt' },
					body1: {  },
					body2: {  },
					subtitle1: {  },
					subtitle2: {  },
					bold: { fontWeight:'bold' },
					greyColor: { color:'#888' },
					redColor: { color:'#F44335' },
					blackColor: { color:'black' },
					blueColor: { color:'#0188D1' },
					labelColor: { color:'#616161' },
					filterIconStyle: { color:'black',height:'14px',width:'14px' },
					dialog: { padding:'5px 10px',border:'1px solid #efefef',borderRadius:'5px',background:'white',marginTop:'10px' },
					lampDialog: { padding:'5px 10px',border:'1px solid #efefef',borderRadius:'5px',background:'white',minWidth:'300px' },
					whiteBlock: { background:'white',borderRadius:'3px',height:'100%',border:'1px solid #efefef' },
					statusStyle: { height:'120px',width:'200px',borderRadius:'5px' },
					statusBadge: { width:'20px',height:'20px',borderRadius:'10px' },
					statusIconStyle: { width:'48px',height:'24px' },
					statusMinimalIconStyle: { width:'32px',height:'16px' },
					verySmallSize: { fontSize:'8pt' },
					veryLargeSize: { fontSize:'30pt' },
					link: { color:'#ff9100' },
					secondary: {  },
					highlightedBlock: { background:'white',padding:'10px',borderRadius:'10px' },
					secondaryHighlighted: { color:'#ff9100',borderBottom:'1px solid white' },
					separator: { borderRight:'1px solid black' },
					main: { minHeight:'100%' },
					footerFormat: { background:'#efefef',padding:'1px 7px',borderTop:'1px solid #aaa' },
					sliderFormat: { padding:'10px 30px',borderTop:'1px solid #aaa' },
					headerSubtitle: { color:'white',position:'absolute',top:0,left:0,marginLeft:'180px',marginTop:'6px',textTransform:'uppercase',fontSize:'9pt' },
					footerStyle: { color:'white',background:'#272C34' },
					whiteBackground: { background:'white' },
					spaced: { padding:'10px' },
					leftSpaced: { paddingLeft:'10px' },
					doubleLeftSpaced: { paddingLeft:'20px' },
					rightSpaced: { paddingRight:'10px' },
					doubleRightSpaced: { paddingRight:'20px' },
					topSpaced: { paddingTop:'10px' },
					middleTopSpaced: { paddingTop:'5px' },
					bottomSpaced: { paddingBottom:'10px' },
					middleBottomSpaced: { paddingBottom:'5px' },
					sortBottomSpaced: { paddingBottom:'3px' },
					airHeader: { padding:'4px 20px' },
					userHeader: { marginTop:'10px',paddingBottom:'10px',borderBottom:'1px solid #ddd' },
					overflowAuto: { overflow:'auto' },
					airTop: { marginTop:'10px' },
					mediumAirTop: { marginTop:'15px' },
					doubleAirTop: { marginTop:'20px' },
					airBottom: { marginBottom:'10px' },
					doubleAirBottom: { marginBottom:'20px' },
					tripleAirBottom: { marginBottom:'40px' },
					doubleAirRight: { marginRight:'20px' },
					smallAirRight: { marginRight:'2px' },
					middleAirTop: { marginTop:'5px' },
					smallAirTop: { marginTop:'2px' },
					smallAirBottom: { marginBottom:'2px' },
					periodToggleSize: { width:'75px' },
					middleAirBottom: { marginBottom:'5px' },
					airLeft: { marginLeft:'10px' },
					doubleAirLeft: { marginLeft:'20px' },
					airTagsLeft: { marginLeft:'3px' },
					airRight: { marginRight:'10px' },
					middleAirLeft: { marginLeft:'5px' },
					middleAirRight: { marginRight:'5px' },
					airMenuRight: { marginRight:'4px' },
					containerAirMedium: { padding:'10px' },
					noAirTop: { paddingTop:'0' },
					containerAirLarge: { padding:'20px' },
					moduleAir: { padding:'10px 20px' },
					filled: { background:'#efefef',padding:'8px',minHeight:'300px' },
					filledNoAir: { background:'#efefef',minHeight:'200px' },
					filledNoAirLarge: { background:'#efefef',minHeight:'400px' },
					headerToolbar: { marginTop:'10px' },
					textCentered: { textAlign:'center' },
					nowrap: { whiteSpace:'nowrap' },
					absolute: { position:'absolute' },
					generatingStyle: { bottom:'0',right:'0',marginBottom:'20px',position:'absolute' },
					valuesLabelFormat: { whiteSpace:'nowrap' },
					bordered: { border:'1px solid #efefef' },
					leftBordered: { borderLeft:'1px solid #efefef' },
					leftStrongBordered: { borderLeft:'1px solid #afafae' },
					rightBordered: { borderRight:'1px solid #efefef' },
					rightStrongBordered: { borderRight:'1px solid #afafae' },
					blueRightBordered: { borderRight:'1px solid #145c9f' },
					topBordered: { borderTop:'1px solid #efefef' },
					topStrongBordered: { borderTop:'1px solid #afafae' },
					bottomBordered: { borderBottom:'1px solid #efefef' },
					bottomStrongBordered: { borderBottom:'1px solid #afafae' },
					bottomBlackBordered: { borderBottom:'1px solid #999999' },
					paperFormat: { minHeight:'300px' },
					underline: { borderBottom:'1px dotted #ddd',width:'100%',marginBottom:'10px' },
					separator: { borderBottom:'1px solid #ddd',width:'100%' },
					description: { fontSize:'10pt',color:'grey' },
					headerWithIndicators: { minHeight:'60px' },
					minHeight: { minHeight:'100%' },
					minImageHeight: { minHeight:'300px',flex:'1' },
					minWidth: { minWidth:'400px' },
					minPropertyWidth: { minWidth:'45px' },
					mapHeight: { height:'180px' },
					minStatWidth: { width:'70px' },
					minMapWidth: { minWidth:'200px' },
					minSliderWidth: { minWidth:'300px' },
					columnMinWidth: { minWidth:'300px' },
					minReportSelectorBlockWidth: { minWidth:'360px' },
					minPhotoWidth: { minWidth:'100px' },
					usersStampFormat: { height:'100%' },
					relative: { position:'relative' },
					endJustified: { textAlign:'end' },
					riskTemplateToolbar: { position:'absolute',bottom:'0',margin:'-16px auto' },
					riskSliderStyle: { padding:'10px 35px' },
					contentCopyDashboardIcon: { position:'absolute',right:'44px',top:'-12px',background:'white',border:'1px solid #efefef' },
					removeDashboardIcon: { position:'absolute',right:'-12px',top:'-12px',background:'white',border:'1px solid #efefef' },
					thesaurus: { overflow:'auto',padding:'10px',minWidth:'300px',minHeight:'400px' },
					greyBackground: { background:'#efefef' },
					greyLightBackground: { background:'#fafafa' },
					grey: { color:'#777' },
					greyImage: { filter:'grayscale(100%)' },
					white: { color:'white' },
					loginError: { position:'absolute',bottom:'-10px',textAlign:'center',width:'100%',color:'red' },
					backgroundLogin: { position:'absolute',bottom:'0',top:'0',width:'100%',height:'100%',zIndex:'0' },
					logoLogin: { filter:'brightness(0) invert(1)',position:'absolute',margin:'30px' },
					visible: { zIndex:'1' },
					openUsersButton: { width:'150px' },
					userNotGranted: { fontSize:'20pt',textAlign:'center',marginTop:'40px' },
					selectorWidth: { minWidth:'250px' },
					block: { position:'relative',marginTop:'20px' },
					summaryGroup: { background:'white',padding:'10px',paddingBottom:'5px' },
					transaccionBlock: { padding:'10px',paddingBottom:'5px',borderRadius:'6px',minHeight:'106px' },
					indicator: { width:'200px',marginLeft:'10px' },
					indicatorFull: { width:'100%',marginLeft:'0',height:'80px' },
					estadoFormat: { width:'20px',height:'20px',marginRight:'10px' },
					gestionesCobro: { background:'#B60200' },
					gestionesColor: { color:'#B60200' },
					cuenta: { background:'#8A1C88' },
					cuentaColor: { color:'#8A1C88' },
					gestionesAnticipo: { background:'#458400' },
					gestionesAnticipoColor: { color:'#458400' },
					fullWidth: { width:'100%' },
					transaccion: { border:'1px solid #eee',paddingLeft:'10px',marginBottom:'4px' },
					tag: { fontSize:'8pt',marginTop:'-5px' },
					atrasadaTag: { fontSize:'8pt',padding:'4px 10px 0',marginTop:'0' },
					pill: { height:'17px',marginRight:'8px',padding:'2px 4px',fontSize:'7pt',marginTop:'2px',textAlign:'center' },
					alertLevelPill: { width:'95px',textAlign:'center' },
					smallAlertLevelPill: { width:'10px',height:'10px',borderRadius:'16px',padding:'0',textAlign:'center' },
					tasaIva: { width:'48px',textAlign:'center' },
					toolbar: { margin:'5px 0px 20px' },
					emptyToolbar: { height:'22px' },
					noPadding: { padding:'0' },
					transaccionStamp: { position:'absolute',fontSize:'13pt',transform:'rotate(16deg)',color:'white',marginTop:'25px',marginLeft:'20px',padding:'0 70px',borderRadius:'8px',background:'black',opacity:'0.6' },
					advise: { background:'#1876D2',color:'white',width:'100%',padding:'6px 21px' },
					historico: { color:'#888',textTransform:'uppercase',fontSize:'6pt',marginRight:'4px' },
					tabs: { width:'400px' },
					minAbsoluteHeight: { minHeight:'100px' },
					menuWidth: { width:'400px' },
					customLinkLeftSpace: { marginLeft:'-3px' },
					borderTop: { borderTop:'2px solid #8abeff' },
					paddingTop: { paddingTop:'10px' },
					changesTextAir: { marginTop:'6px' },
					centered: { margin:'0 auto' },
					alertLevelStyle: { width:'80px',textAlign:'left' },
					unselectable: { cursor:'default' },
					alertsExpandedBlock: { width:'480px',border:'1px solid #CCC',height:'100%',padding:'6px 10px',marginLeft:'10px' },
					assetAlertsExpandedBlockWidth: { width:'350px' },
					metricStyle: { fontSize:'8pt',marginLeft:'5px',color:'#777' },
					filterDialog: { background:'#efefef',padding:'0 10px',borderRadius:'4px',margin:'0 0 12px 20px',border:'1px solid #efefef' },
					workOrderFilterDialog: { margin:'0 0 -10px 20px' },
					indicatorStyle: { width:'250px',height:'150px',border:'1px solid #ddd',margin:'10px 20px 10px 0',borderRadius:'10px' },
					histogramStyle: { minWidth:'450px' },
					fullHeight: { height:'100%' },
					measurementBlockStyle: { marginTop:'10px',background:'white',padding:'10px' },
					reportBlockStyle: { marginTop:'10px',background:'white',padding:'10px' },
					viewSelectorStyle: { height:'41px' },
					periodSelectorStyle: { position:'absolute',left:0,background:'#fafafa',marginLeft:'53px',width:'220px',fontSize:'8pt',top:'0',marginTop:'3px' },
					modeSelectorStyle: { position:'absolute',right:0,background:'#fafafa',fontSize:'8pt',top:'-3px',marginTop:'-4px' },
					pendingBlockStyle: { borderTop:'1px solid black',padding:'10px 0',position:'absolute',width:'100%',height:'100%',marginTop:'-3px' },
					pendingBlockTextStyle: { position:'absolute',right:'0',top:'0',color:'black' },
					minAssetSummaryBlockWidth: { minWidth:'300px' },
					assetModeStyle: { width:'16px',height: '16px',borderRadius:'10px',padding:'0' },
					assetModeOnStyle: { border:'3px solid black' },
					assetModeOffStyle: { border:'3px solid black',opacity:'0.2' },
					assetModeOfflineStyle: { background:'white',border:'3px solid #E93223' },
					assetModeNoInformationStyle: { display:'none' },
					homeModeSelector: { marginLeft:'-7px',width:'120px' },
					summaryScreenTableHeight: { height:'20px' },
					summaryOrderTableHeight: { height:'20px' },
					courierNewFont: { fontFamily:'Courier New',marginTop:'4px',fontWeight:'bold' },
					toolbarButton: { border:'1px solid #c4c4c4',borderRadius:'4px',padding:'7px' },
					cubeStyle: { margin:'0 20px 20px 0',height:'100%' },
					filtersBlockStyle: { marginTop:'45px' },
					orangeBorder: { border:'1px solid #f89101' },
					smallIconSize: { width:'16px',height:'16px' },
					mediumIconSize: { width:'21px',height:'21px' },
					cubeDialogStyle: { background:'white',border:'1px solid #eee',position:'relative' },
					filtersSummaryStyle: { position:'absolute',bottom:'0',left:'0',marginLeft:'10px',marginBottom:'4px' },
					addFiltersSummaryStyle: { position:'absolute',bottom:'0',left:'0',marginLeft:'10px',marginBottom:'-33px',zIndex:'1' },
					zoomLevelStyle: { position:'absolute',bottom:'0px',right:'0px',marginRight:'470px',marginBottom:'-35px',zIndex:'1',right:'0' },
					swapStyle: { marginTop:'24px' },
					loginBackground: { background:'black url(trooper-elements/res/login-background.jpg) no-repeat center' },
					loginLoading: { padding:'20px' },
					rotate: { transform:'rotate(270deg)' },
					rotate90: { transform:'rotate(90deg)' },
					refreshBlockStyle: { minWidth:'110px' },
					noAvailableStyle: { color:'red' },
					tabsStyle: { height:'24px',minHeight:'24px' },
					tabStyle: { height:'19px' },
					appTitleStyle: { marginTop:'14px' },
					appDescriptionStyle: { color:'#888' },
					smallTag: { fontSize:'6pt',marginTop:'-2px' },
					headerHeight: { height:'70px' },
					listViewStyle: { paddingTop:'3px' },
					tableViewStyle: { paddingTop:'3px' },
					barChartStyle: { margin:'-3px 0 0',padding:'0',paddingRight:'0',paddingLeft:'5px' },
					cardTitle: { textAlign:'left',color:'#B71A1C',padding:'10px' },
					cardContent: { textAlign:'left',padding:'10px' },
					overflowRevert: { overflow:'revert' },
					progressHeight: { minHeight:'20px' },
					savingStyle: { bottom:'0',right:'0',marginBottom:'21px',position:'absolute',background:'#006cad',color:'white',marginRight:'2px',padding:'0px 25px' },
					topDottedBordered: { borderTop:'1px dotted #efefef' },
					checkListWizardIndexEntryStyle: { height:'auto' },
					htmlSize: { fontSize:'9pt' },
					secondaryColor: { color:'#ff9100' },
					orderEditorWithPhoto: { minHeight:'450px',marginRight:'15px' },
					cleanHtmlStyle: { background:'none',border:'0',padding:'0' }
				}
			});
            theme.isLight = () => {
                return theme.palette.type == "light";
            };
            theme.isDark = () => {
                return theme.palette.type == "dark";
            };
            theme.onChangeMode = (listener) => {
                theme.changeModeListener = listener;
            }
            theme.setMode = (mode) => {
                theme.changeModeListener(mode);
            }
			return theme;
		},
		get: () => {
			return theme;
		},
	};
	return provider;
})();

function property(name) {
    var theme = Theme.get();
    if (theme == null) return;
    var parts = name.split(".");
    var property = theme;
    for (var i=0; i<parts.length; i++) property = property[parts[i]];
    return property;
}

export default Theme;