package io.intino.monet.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.components.BlockConditional;
import io.intino.monet.box.MonetBox;

import java.util.Arrays;

public class AppTemplate extends AbstractAppTemplate<MonetBox> {
    private Page current = null;
    private boolean embedded = false;

    public AppTemplate(MonetBox box) {
        super(box);
    }

    public void embedded(boolean embedded) {
        if (!embedded) return;
        header.embedded(true);
        this.embedded = embedded;
    }

    public enum Page {
        OrderTypes, Order;

        public static Page from(String key) {
            return Arrays.stream(values()).filter(v -> v.name().equalsIgnoreCase(key)).findFirst().orElse(null);
        }
    }

    public void openHome() {
        openOrderTypes();
    }

    public void openOrderTypes() {
        openPage(Page.OrderTypes);
        if (orderTypesPage.orderTypesStamp != null) orderTypesPage.orderTypesStamp.refresh();
    }

    public void openOrder(String id) {
        openPage(Page.Order);
        if (orderPage.orderStamp != null) orderPage.orderStamp.open(id);
    }

    @Override
    public void refresh() {
        super.refresh();
        refreshCurrentPage();
    }

    private boolean openPage(Page page) {
        if (page == current) return false;
        loading.visible(false);
        header.refresh();
        hideBlocks();
        blockOf(page).show();
        current = page;
        return true;
    }

    private void hideBlocks() {
        if (orderTypesPage.isVisible()) orderTypesPage.hide();
        if (orderPage.isVisible()) orderPage.hide();
    }

    private BlockConditional blockOf(Page page) {
        if (page == Page.OrderTypes) return orderTypesPage;
        if (page == Page.Order) return orderPage;
        return null;
    }

    private void refreshCurrentPage() {
        if (current == Page.OrderTypes) orderTypesPage.orderTypesStamp.refresh();
        else if (current == Page.Order) orderPage.orderStamp.refresh();
    }

}