package io.intino.monet.box.ui.displays.requesters;

import io.intino.monet.box.ui.displays.templates.OrderTemplate;
import io.intino.monet.box.ui.displays.templates.OrderTemplateProxy;
import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.spark.UISparkManager;

public class OrderTemplateProxyRequester extends io.intino.alexandria.ui.displays.requesters.DisplayProxyRequester {

	public OrderTemplateProxyRequester(UISparkManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		String operation = operation();
		OrderTemplate display = personifiedDisplay();
		if (display == null) return;
		if (operation.equals("refreshPersonifiedDisplay")) {
			display.orderId(manager.fromQuery("orderId"));
			display.author(manager.fromQuery("author"));
			display.refresh();
			return;
		}
		super.execute();
	}
}