package io.intino.monet.box;

import io.intino.monet.box.workreports.PdfWorkReportGenerator;
import io.intino.monet.engine.WorkReport;
import io.intino.monet.engine.edition.Form;

import java.io.File;
import java.time.Instant;

public class DefaultWorkReportGenerator implements WorkReportGenerator {

	private final Archetype archetype;

	public DefaultWorkReportGenerator(Archetype archetype) {
		this.archetype = archetype;
	}

	@Override
	public boolean canGenerate(WorkReport workReport, Form form) {
		return true;
	}

	@Override
	public File generate(WorkReport workReport, Form form, boolean preview) {
		File reportFile = reportFile(workReport);
		PdfWorkReportGenerator generator = new PdfWorkReportGenerator(archetype, reportFile);
		generator.generate(workReport);
		return reportFile;
	}

	private File reportFile(WorkReport report) {
		return new File(archetype.tmp(), Instant.now().toString().replace(":", "") + ".pdf");
	}

}
