/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.box.workreports;

import io.intino.alexandria.office.DocxBuilder;
import io.intino.alexandria.office.components.ImageView;
import io.intino.alexandria.office.components.Paragraph;
import io.intino.alexandria.office.components.Style;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class WorkReportTemplate {
    private final String name;
    private final File file;
    private final DocxBuilder docxBuilder;
    private boolean empty = true;
    private final Map<String, Paragraph> fields = new LinkedHashMap<String, Paragraph>();
    private final Set<String> images = new LinkedHashSet<String>();
    private boolean isMain = false;
    private final Map<String, String> extraInfo = new HashMap<String, String>(1);
    protected static final Pattern XML_INVALID_CHARACTERS = Pattern.compile("[^\\u0009\\u000A\\u000D\\u0020-\\uD7FF\\uE000-\\uFFFD\\x{10000}-\\x{10FFFF}]");

    public WorkReportTemplate(String name, File templateFile) {
        this.name = name;
        if (!templateFile.exists()) {
            throw new IllegalArgumentException("Template file " + templateFile + " does not exist");
        }
        this.file = templateFile;
        this.docxBuilder = DocxBuilder.create((File)templateFile);
    }

    public String name() {
        return this.name;
    }

    public File file() {
        return this.file;
    }

    public boolean contains(String field) {
        return this.fields.containsKey(field);
    }

    public boolean containsImage(String field) {
        return this.images.contains(field);
    }

    public WorkReportTemplate set(String field, String value) {
        if (value == null) {
            return this;
        }
        this.fields.put(field, new Paragraph().text(value, new Style[0]));
        this.docxBuilder.replace(field, WorkReportTemplate.escape(value));
        this.empty &= value.isEmpty();
        return this;
    }

    public WorkReportTemplate set(String field, Paragraph value) {
        if (value == null) {
            return this;
        }
        this.fields.put(field, value);
        this.docxBuilder.replace(field, value);
        this.empty = false;
        return this;
    }

    public WorkReportTemplate set(String field, ImageView value) {
        if (value == null) {
            return this;
        }
        this.images.add(field);
        this.docxBuilder.replace(field, value);
        this.empty = false;
        return this;
    }

    public void save(File file) throws IOException {
        this.docxBuilder.save(file);
    }

    public boolean empty() {
        return this.empty;
    }

    public Map<String, String> extraInfo() {
        return this.extraInfo;
    }

    public String toString() {
        return "WorkReportTemplate:" + this.file.toString();
    }

    public boolean isMainTemplate() {
        return this.isMain;
    }

    void setAsMainTemplate() {
        this.isMain = true;
    }

    protected static String escape(String value) {
        if (value == null || value.isEmpty()) {
            return "";
        }
        return "<![CDATA[" + WorkReportTemplate.stripInvalidXMLCharacters(value) + "]]>";
    }

    private static String stripInvalidXMLCharacters(String str) {
        return XML_INVALID_CHARACTERS.matcher(str).replaceAll("");
    }
}

