/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.box.workreports;

import io.intino.alexandria.Resource;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.office.components.Image;
import io.intino.alexandria.office.components.ImageView;
import io.intino.monet.box.ImageViewFactory;
import io.intino.monet.box.WorkReportGenerator;
import io.intino.monet.box.util.Resources;
import io.intino.monet.box.util.WorkReportHelper;
import io.intino.monet.box.workreports.WorkReportInfoProvider;
import io.intino.monet.box.workreports.WorkReportTemplate;
import io.intino.monet.engine.CheckListProvider;
import io.intino.monet.engine.Order;
import io.intino.monet.engine.OrderTypes;
import io.intino.monet.engine.WorkReport;
import io.intino.monet.engine.edition.FormStore;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class WorkReportBuilder {
    private static final String MAIN_TEMPLATE_NAME = "000000_main";
    private final WorkReportGenerator.Archetype archetype;
    private WorkReport workReport;
    private WorkReportInfoProvider infoProvider;
    private OrderTypes.Checklist checklist;
    private final Map<String, WorkReportTemplate> templates = new TreeMap<String, WorkReportTemplate>();
    private ImageViewFactory imageViewFactory = new ImageViewFactory.Default();
    private boolean computeCalculations = true;
    private static final Set<String> InvalidValues = Set.of(String.valueOf(FormStore.skipped), String.valueOf(FormStore.disabled), String.valueOf(FormStore.hidden));

    public WorkReportBuilder(WorkReportGenerator.Archetype archetype) {
        this.archetype = archetype;
    }

    public Map<String, WorkReportTemplate> build() throws WorkReportException {
        this.validate();
        this.templates.clear();
        this.buildDocuments();
        return this.templates;
    }

    private void buildDocuments() throws WorkReportException {
        this.createMainTemplate();
        this.fillWorkReportTemplates();
    }

    private void fillWorkReportTemplates() throws WorkReportException {
        this.setInputs(this.mainTemplate());
        this.setBasicInfo(this.mainTemplate());
        TreeMap<String, String> workReportChecks = new TreeMap<String, String>(this.computeCalculations ? this.withCalculations() : this.workReport.attributes());
        this.setChecksAndCalculations(workReportChecks);
        this.setImages();
        this.handleNotDefinedImages();
        this.setDefaultValuesForNotProcessedChecks(workReportChecks);
    }

    protected void setChecksAndCalculations(Map<String, String> workReportChecks) throws WorkReportException {
        for (Map.Entry<String, String> checkEntry : workReportChecks.entrySet()) {
            WorkReportTemplate template;
            String name = checkEntry.getKey();
            String value = checkEntry.getValue();
            if (value == null) continue;
            OrderTypes.Checklist.Field check = this.getCheck(name);
            WorkReportTemplate workReportTemplate = template = check != null ? this.templateOf(check) : this.templateOf(name);
            if (template == null) {
                Logger.warn((String)("Template of " + name + " not found..."));
                return;
            }
            this.setTemplateFields(name, value, template);
        }
    }

    private void setTemplateFields(String name, String value, WorkReportTemplate template) {
        value = value.replace("<br/>", "\n");
        template.set(this.checkName(name), value);
    }

    private void setAnnexFields(OrderTypes.Checklist.Field field, OrderTypes.Checklist.Annex annex, String value, WorkReportTemplate template) {
        if (annex == null || annex.type() == OrderTypes.Checklist.Annex.Type.shared) {
            return;
        }
        OrderTypes.Checklist.AnnexInstance annexInstance = (OrderTypes.Checklist.AnnexInstance)annex;
        for (Map.Entry attribute : annexInstance.attributes(this.workReport().language()).entrySet()) {
            template.set((String)attribute.getKey(), (String)attribute.getValue());
        }
        template.set("$value", this.isValidValue(value) ? value : "");
        template.set("$instance.index", template.extraInfo().get("$instance.index"));
        if (field.marker() != null) {
            this.setMarkerParameters(field, template);
        }
    }

    private boolean isValidValue(String value) {
        return !InvalidValues.contains(value);
    }

    private void setMarkerParameters(OrderTypes.Checklist.Field field, WorkReportTemplate template) {
        for (Map.Entry entry : field.marker().entries().entrySet()) {
            String name = (String)entry.getKey();
            if (!this.matchesLanguageOrIsGlobal(name, this.workReport.language())) continue;
            name = name.endsWith("." + this.workReport.language()) ? name.replace("." + this.workReport.language(), "") : name;
            template.set("$marker." + name, (String)entry.getValue());
        }
    }

    private boolean matchesLanguageOrIsGlobal(String name, String language) {
        int langStart = name.lastIndexOf(46);
        if (langStart < 0) {
            return true;
        }
        String attribLang = name.substring(langStart + 1);
        if (Locale.forLanguageTag(attribLang) == null) {
            return true;
        }
        return language.equals(attribLang);
    }

    private void setDefaultValuesForNotProcessedChecks(Map<String, String> workReportChecks) throws WorkReportException {
        Set checks = this.checklist.fields().stream().map(f -> f.name).collect(Collectors.toSet());
        HashSet notProcessedChecks = new HashSet(checks);
        notProcessedChecks.removeAll(workReportChecks.keySet());
        for (WorkReportTemplate template : this.templates.values()) {
            for (String check : notProcessedChecks) {
                if (!WorkReportBuilder.isCheckOfTemplate(template, check)) continue;
                if (check.contains("+")) {
                    check = check.substring(0, check.indexOf(43));
                }
                if (template.contains(check)) continue;
                template.set(check, "");
            }
        }
        HashSet processedChecks = new HashSet(checks);
        processedChecks.retainAll(workReportChecks.keySet());
        for (String check : processedChecks) {
            WorkReportTemplate template;
            OrderTypes.Checklist.Field field = this.getCheck(check);
            if (field == null || (template = this.templateOf(field)).empty()) continue;
            this.setAnnexFields(field, field.annex(), workReportChecks.get(check), template);
        }
    }

    private OrderTypes.Checklist.Field getCheck(String name) {
        return this.checklist.fields().stream().filter(f -> f.name.equals(name)).findFirst().orElse(null);
    }

    protected void setBasicInfo(WorkReportTemplate mainTemplate) {
        this.infoProvider.info().forEach(mainTemplate::set);
    }

    protected void setInputs(WorkReportTemplate mainTemplate) {
        Order order = this.workReport.order();
        if (order.inputMap() != null) {
            order.inputMap().forEach(mainTemplate::set);
        }
    }

    private Map<String, String> withCalculations() {
        return WorkReportHelper.addCalculationsTo(this.workReport.attributes(), this.workReport.order(), this.archetype.orderTypes());
    }

    protected void setImages() {
        for (Resource image : this.workReport.images()) {
            this.setImage(image);
        }
    }

    private void handleNotDefinedImages() {
        for (WorkReportTemplate template : this.templates.values()) {
            this.imagesOfTemplate(template).forEach(check -> this.tryPut((OrderTypes.Checklist.Field)check, template));
        }
    }

    private void tryPut(OrderTypes.Checklist.Field check, WorkReportTemplate template) {
        String name;
        String string = name = check.name.contains("+") ? check.name.substring(0, check.name.indexOf(43)) : check.name;
        if (template.containsImage(name)) {
            return;
        }
        byte[] imageData = this.getImageForTemplateState(template);
        if (imageData.length == 0) {
            return;
        }
        try {
            this.setImage(name, check.annex(), template, imageData);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private Stream<OrderTypes.Checklist.Field> imagesOfTemplate(WorkReportTemplate template) {
        return this.checklist.fields().stream().filter(this::isImageCheck).filter(c -> WorkReportBuilder.isCheckOfTemplate(template, c.name));
    }

    private static boolean isCheckOfTemplate(WorkReportTemplate template, String checkName) {
        if (checkName.contains("+")) {
            return checkName.endsWith("+" + template.name());
        }
        return template.isMainTemplate();
    }

    private boolean isImageCheck(OrderTypes.Checklist.Field field) {
        return field.type == OrderTypes.Checklist.Type.Image || field.type == OrderTypes.Checklist.Type.Note || field.type == OrderTypes.Checklist.Type.Signature;
    }

    protected void setImage(Resource image) {
        try {
            OrderTypes.Checklist.Field check = this.getCheck(image.name());
            OrderTypes.Checklist.Annex annex = check == null ? null : check.annex();
            byte[] imageData = image.bytes();
            if (annex != null && annex.type() == OrderTypes.Checklist.Annex.Type.instance && imageData.length == 0) {
                return;
            }
            WorkReportTemplate template = this.templateOf(check);
            if (template == null) {
                Logger.warn((String)("Template of " + image.name() + " not found..."));
                return;
            }
            if (imageData.length == 0) {
                imageData = this.getImageForTemplateState(template);
            }
            if (imageData.length == 0) {
                return;
            }
            this.setImage(image.name(), check == null ? null : check.annex(), template, imageData);
        }
        catch (Throwable e) {
            Logger.error((String)("Failed to create image " + image.name() + ": " + e.getMessage()), (Throwable)e);
        }
    }

    private void setImage(String name, OrderTypes.Checklist.Annex annex, WorkReportTemplate template, byte[] imageData) throws IOException {
        ImageView imageView = this.imageViewFactory.create(new Image(imageData));
        template.set(this.checkName(name), imageView);
        if (annex != null && annex.type() == OrderTypes.Checklist.Annex.Type.instance) {
            template.set("$value", imageView);
        }
    }

    private byte[] getImageForTemplateState(WorkReportTemplate template) {
        return !template.empty() || template.isMainTemplate() ? this.blankImage() : new byte[]{};
    }

    private byte[] blankImage() {
        byte[] byArray;
        block8: {
            InputStream inputStream = Resources.emptyImage();
            try {
                byArray = inputStream.readAllBytes();
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Logger.error((String)("Could not read empty image: " + e.getMessage()), (Throwable)e);
                    return new byte[0];
                }
            }
            inputStream.close();
        }
        return byArray;
    }

    private void createMainTemplate() {
        WorkReportTemplate template = new WorkReportTemplate(MAIN_TEMPLATE_NAME, WorkReportHelper.template(this.archetype.orderTypes(), this.workReport.area(), this.workReport.order(), this.workReport.language()));
        template.setAsMainTemplate();
        this.templates.put(MAIN_TEMPLATE_NAME, template);
    }

    private WorkReportTemplate templateOf(OrderTypes.Checklist.Field check) throws WorkReportException {
        return check == null ? this.mainTemplate() : this.templateOf(check.annex());
    }

    private WorkReportTemplate templateOf(OrderTypes.Checklist.Annex annex) throws WorkReportException {
        if (annex == null) {
            return this.mainTemplate();
        }
        return annex.type() == OrderTypes.Checklist.Annex.Type.instance ? this.newWorkReportTemplate(annex) : this.sharedWorkReportTemplate(annex);
    }

    private WorkReportTemplate sharedWorkReportTemplate(OrderTypes.Checklist.Annex annex) throws WorkReportException {
        if (!this.templates.containsKey(annex.name)) {
            this.templates.put(annex.name, this.templateOfFilename(annex.name, this.orderType().annexFilenameOf(annex.name)));
        }
        return this.templates.get(annex.name);
    }

    private WorkReportTemplate newWorkReportTemplate(OrderTypes.Checklist.Annex annex) throws WorkReportException {
        OrderTypes.Checklist.AnnexInstance annexInstance = (OrderTypes.Checklist.AnnexInstance)annex;
        if (!this.templates.containsKey(annexInstance.instanceName)) {
            WorkReportTemplate template = this.templateOfFilename(annexInstance.instanceName, this.orderType().annexFilenameOf(annex.name));
            this.templates.put(annexInstance.instanceName, template);
            template.extraInfo().put("$instance.index", String.valueOf(this.countTemplateInstances(annexInstance.name)));
        }
        return this.templates.get(annexInstance.instanceName);
    }

    private int countTemplateInstances(String name) {
        return (int)this.templates.keySet().stream().filter(k -> k.startsWith(name)).count();
    }

    private WorkReportTemplate templateOf(String name) {
        if (!name.contains("+")) {
            return this.mainTemplate();
        }
        String templateId = name.substring(name.indexOf(43) + 1);
        return this.templates.get(templateId);
    }

    private WorkReportTemplate templateOfFilename(String name, String filename) {
        return new WorkReportTemplate(name, new File(this.mainTemplate().file().getParentFile(), filename));
    }

    protected WorkReportTemplate mainTemplate() {
        return this.templates.get(MAIN_TEMPLATE_NAME);
    }

    protected String checkName(String name) {
        return !name.contains("+") ? name : name.substring(0, name.indexOf(43));
    }

    protected void validate() throws WorkReportException {
        if (this.workReport == null) {
            throw new WorkReportException("WorkReport is null");
        }
        if (this.workReport.order() == null) {
            throw new WorkReportException("WorkReport orderId is null");
        }
        if (this.workReport.language() == null) {
            throw new WorkReportException("Language is not specified");
        }
        this.checklist = new CheckListProvider().findCheckList(this.workReport.order().code());
        if (this.checklist == null) {
            throw new WorkReportException("No checklist found for order " + this.workReport.order().code());
        }
    }

    public <T extends WorkReport> T workReport() {
        return (T)this.workReport;
    }

    private OrderTypes.Record orderType() throws WorkReportException {
        Order order = this.workReport.order();
        OrderTypes.Record orderType = OrderTypes.of((String)order.code());
        if (orderType == null) {
            throw new WorkReportException("OrderType not found for order " + order.code());
        }
        return orderType;
    }

    public WorkReportBuilder workReport(WorkReport workReport) {
        this.workReport = workReport;
        return this;
    }

    public WorkReportBuilder infoProvider(WorkReportInfoProvider infoProvider) {
        this.infoProvider = infoProvider;
        return this;
    }

    public WorkReportBuilder imageViewFactory(ImageViewFactory imageViewFactory) {
        this.imageViewFactory = imageViewFactory == null ? new ImageViewFactory.Default() : imageViewFactory;
        return this;
    }

    public WorkReportBuilder computeCalculations(boolean computeCalculations) {
        this.computeCalculations = computeCalculations;
        return this;
    }

    public static class WorkReportException
    extends Exception {
        public WorkReportException(String message) {
            super(message);
        }
    }
}

