/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.box.workreports;

import io.intino.alexandria.Json;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.office.PdfBuilder;
import io.intino.alexandria.office.PdfDecorator;
import io.intino.alexandria.office.PdfMerger;
import io.intino.alexandria.office.PdfMetadata;
import io.intino.monet.box.WorkReportGenerator;
import io.intino.monet.box.workreports.WorkReportBuilder;
import io.intino.monet.box.workreports.WorkReportInfoProvider;
import io.intino.monet.box.workreports.WorkReportTemplate;
import io.intino.monet.engine.WorkReport;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.poi.openxml4j.util.ZipSecureFile;

public class PdfWorkReportGenerator {
    protected final WorkReportGenerator.Archetype archetype;
    protected final File destination;
    protected WorkReportBuilder builder;
    protected WorkReportInfoProvider infoProvider;

    public PdfWorkReportGenerator(WorkReportGenerator.Archetype archetype, File destination) {
        this.archetype = archetype;
        this.destination = destination;
        this.builder = new WorkReportBuilder(archetype);
        this.infoProvider = new WorkReportInfoProvider();
    }

    public PdfWorkReportGenerator builder(WorkReportBuilder builder) {
        this.builder = builder;
        return this;
    }

    public PdfWorkReportGenerator infoProvider(WorkReportInfoProvider provider) {
        this.infoProvider = provider;
        return this;
    }

    public void generate(WorkReport workReport) {
        try {
            Map<String, WorkReportTemplate> templates = this.setWorkReportInformation(workReport);
            List<File> pdfDocuments = this.generateTempPdfDocuments(templates);
            this.mergeAndGenerateTheFinalWorkReportDocument(pdfDocuments);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    protected void mergeAndGenerateTheFinalWorkReportDocument(List<File> pdfDocuments) throws IOException {
        try {
            if (pdfDocuments.size() == 1) {
                this.moveToDestination(pdfDocuments.get(0));
            } else {
                this.mergeIntoTheFinalDocument(pdfDocuments);
            }
            this.setMetadata();
        }
        finally {
            pdfDocuments.forEach(File::delete);
        }
    }

    protected void setMetadata() {
        try {
            Object workReport = this.builder.workReport();
            PdfMetadata metadata = new PdfMetadata(this.destination);
            metadata.setCreator("monet");
            metadata.setProducer("monet");
            metadata.setAuthor(workReport.order().property("author"));
            metadata.setCustomValue("input", workReport.order().input());
            metadata.setCustomValue("checklist", Json.toString((Object)workReport.attributes()));
            new PdfDecorator(this.destination).setMetadata(metadata).save(this.destination);
        }
        catch (Exception e) {
            Logger.debug((String)("Could not add metadata to pdf: " + e.getClass().getSimpleName() + " => " + e.getMessage()));
        }
    }

    protected void mergeIntoTheFinalDocument(List<File> pdfDocuments) throws IOException {
        PdfMerger merger = new PdfMerger();
        pdfDocuments.forEach(arg_0 -> ((PdfMerger)merger).append(arg_0));
        merger.merge(this.destination);
    }

    protected void moveToDestination(File file) throws IOException {
        Files.move(file.toPath(), this.destination.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    protected List<File> generateTempPdfDocuments(Map<String, WorkReportTemplate> templates) {
        return templates.values().stream().map(this::generateDocumentFor).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected File generateDocumentFor(WorkReportTemplate template) {
        ZipSecureFile.setMinInflateRatio((double)0.0);
        File tmpFile = new File(this.archetype.tmp(), this.currentInstant() + ".docx");
        File pdfFile = new File(this.archetype.tmp(), this.currentInstant() + ".pdf");
        if (template.empty()) {
            return null;
        }
        PdfWorkReportGenerator.saveTemplateToPdf(template, tmpFile, pdfFile);
        return pdfFile;
    }

    protected static void saveTemplateToPdf(WorkReportTemplate template, File tmpFile, File pdfFile) {
        try {
            template.save(tmpFile);
            PdfBuilder.create((File)tmpFile).save(pdfFile);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while generating pdf of " + template.file() + ": " + e.getMessage(), e);
        }
        finally {
            tmpFile.delete();
        }
    }

    protected String currentInstant() {
        return Instant.now().toString().replace(":", "");
    }

    protected Map<String, WorkReportTemplate> setWorkReportInformation(WorkReport workReport) throws WorkReportBuilder.WorkReportException {
        this.infoProvider.workReport(workReport);
        return this.builder.workReport(workReport).infoProvider(this.infoProvider).build();
    }
}

