/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.box.util;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFName;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class WorkReportCalculator {
    public Map<String, String> map;
    private final Map<String, XSSFCell> indexes = new HashMap<String, XSSFCell>();
    private XSSFWorkbook wb;
    private static final DataFormatter formatter = new DataFormatter();

    public WorkReportCalculator(File file, Map<String, String> map) throws IOException, InvalidFormatException {
        this.wb = new XSSFWorkbook(file);
        this.map(map);
    }

    public WorkReportCalculator map(Map<String, String> map) {
        this.map = map;
        return this;
    }

    public Map<String, String> update() {
        this.replace(this.wb);
        this.update(this.wb);
        return this.map;
    }

    public Map<String, String> update(String key, String value) {
        String parameter = this.parameter(key);
        if (!this.indexes.containsKey(parameter)) {
            return this.map;
        }
        this.map.put(key, value);
        this.replace(this.indexes.get(parameter), parameter);
        this.update(this.wb);
        return this.map;
    }

    private String parameter(String key) {
        return ":" + key + ":";
    }

    private void update(XSSFWorkbook wb) {
        List<XSSFName> names = this.namesOf(wb);
        XSSFFormulaEvaluator evaluator = wb.getCreationHelper().createFormulaEvaluator();
        XSSFSheet sheet = wb.getSheetAt(0);
        for (XSSFName name : names) {
            String key = name.getNameName();
            Cell cell = this.cell(sheet, name.getRefersToFormula());
            String value = this.valueOf(cell, (FormulaEvaluator)evaluator);
            this.put(key, value);
        }
    }

    private List<XSSFName> namesOf(XSSFWorkbook wb) {
        return wb.getAllNames();
    }

    private void put(String key, String value) {
        if (value == null) {
            return;
        }
        this.map.put(key, value);
    }

    private String valueOf(Cell cell, FormulaEvaluator evaluator) {
        if (cell == null) {
            return null;
        }
        return formatter.formatCellValue(cell, evaluator);
    }

    private Cell cell(XSSFSheet sheet, String coordinates) {
        CellReference reference = new CellReference(coordinates);
        XSSFRow row = sheet.getRow(reference.getRow());
        return row != null ? row.getCell((int)reference.getCol()) : null;
    }

    private void replace(XSSFWorkbook wb) {
        XSSFSheet sheet = wb.getSheetAt(0);
        for (int i = sheet.getFirstRowNum(); i < sheet.getLastRowNum(); ++i) {
            this.replace(sheet.getRow(i));
        }
    }

    private void replace(XSSFRow row) {
        if (row == null) {
            return;
        }
        for (int j = row.getFirstCellNum(); j < row.getLastCellNum(); ++j) {
            this.replace(row.getCell(j));
        }
    }

    private void replace(XSSFCell cell) {
        if (cell == null || cell.getCellType() != CellType.STRING) {
            return;
        }
        this.replace(cell, cell.getStringCellValue());
    }

    private void replace(XSSFCell cell, String key) {
        if (key.length() < 2 || key.charAt(0) != ':' || key.charAt(key.length() - 1) != ':') {
            return;
        }
        this.indexes.put(key, cell);
        cell.setCellValue(this.map.getOrDefault(key.substring(1, key.length() - 1), ""));
    }
}

