/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.box.util;

import java.text.Normalizer;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class SearchHelper {
    public static List<String> filter(List<String> options, String condition) {
        String[] conditions = condition != null ? condition.toLowerCase().split(" ") : new String[]{};
        return SearchHelper.filter(options, conditions);
    }

    public static List<String> filter(List<String> options, String[] condition) {
        if (condition.length <= 0) {
            return options;
        }
        return options.stream().filter(o -> SearchHelper.matches(o, condition)).collect(Collectors.toList());
    }

    public static boolean matches(String value, String[] conditions) {
        if (value == null) {
            return false;
        }
        String cleanedValue = SearchHelper.clean(value.toLowerCase());
        return Arrays.stream(conditions).allMatch(c -> cleanedValue.contains(SearchHelper.clean(c)));
    }

    private static String clean(String value) {
        value = Normalizer.normalize(value, Normalizer.Form.NFD);
        value = value.replaceAll("[\\p{InCombiningDiacriticalMarks}]", "");
        return value;
    }
}

