/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.box.ui.displays.templates;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.monet.box.MonetBox;
import io.intino.monet.box.WorkReportGenerator;
import io.intino.monet.box.commands.order.OrderCommands;
import io.intino.monet.box.ui.displays.ProgressDisplay;
import io.intino.monet.box.ui.displays.notifiers.OrderTemplateNotifier;
import io.intino.monet.box.ui.displays.templates.AbstractOrderTemplate;
import io.intino.monet.box.ui.displays.templates.CheckListWizardIndexEntry;
import io.intino.monet.box.util.FormHelper;
import io.intino.monet.box.util.OrderHelper;
import io.intino.monet.box.util.WorkReportCalculator;
import io.intino.monet.box.util.WorkReportHelper;
import io.intino.monet.engine.Order;
import io.intino.monet.engine.OrderTypes;
import io.intino.monet.engine.edition.Edition;
import io.intino.monet.engine.edition.Field;
import io.intino.monet.engine.edition.FieldType;
import io.intino.monet.engine.edition.Form;
import io.intino.monet.engine.edition.FormDefinition;
import io.intino.monet.engine.edition.FormStore;
import io.intino.monet.engine.edition.Language;
import io.intino.monet.engine.edition.LocalFormStore;
import io.intino.monet.engine.edition.editors.DateEdition;
import io.intino.monet.engine.edition.editors.NumberEdition;
import io.intino.monet.engine.edition.editors.OptionMultipleEdition;
import io.intino.monet.engine.edition.editors.SectionEdition;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.LocalDate;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;

public class OrderTemplate
extends AbstractOrderTemplate<OrderTemplateNotifier, MonetBox> {
    private Order order;
    private String author;
    private Form form;
    private WorkReportCalculator formulaCalculator;
    private BiConsumer<File, Form> completeListener;
    private boolean testEnvironment = false;
    private Field previous;
    private Field current;

    public void orderId(String orderId) {
        this.order(((MonetBox)this.box()).orderApi().order(orderId));
    }

    public void author(String author) {
        this.author = author;
    }

    public OrderTemplate(MonetBox box) {
        super(box);
    }

    public void open(String id) {
        this.order(((MonetBox)this.box()).orderApi().order(id));
        this.refresh();
    }

    public OrderTemplate order(Order order) {
        this.order = order;
        this.form = order != null ? new Form(this.formDefinition(), this.store()) : null;
        this.current = this.form != null ? this.form.start(Language.valueOf((String)this.language())) : null;
        this.createFormulaCalculator();
        return this;
    }

    public void testEnvironment(boolean value) {
        this.testEnvironment = value;
    }

    public void onComplete(BiConsumer<File, Form> listener) {
        this.completeListener = listener;
    }

    @Override
    public void init() {
        super.init();
        this.editionBlock.onInit(e -> this.initEdition());
        this.editionBlock.onShow(e -> this.refreshEdition());
        this.previewBlock.onShow(e -> this.refreshPreview());
        this.previewBlock.onHide(e -> this.removePreview());
        this.indexBlock.onShow(e -> this.refreshIndex());
        this.current = this.form != null ? this.form.start(Language.valueOf((String)this.language())) : null;
        this.initToolbar();
        this.refresh();
    }

    public void refresh() {
        super.refresh();
        this.orderNotFoundBlock.visible(this.order == null);
        this.orderFoundBlock.visible(this.order != null);
        this.orderCompletedBlock.visible(false);
        if (this.order == null) {
            return;
        }
        this.refreshResolveOrderDialog();
        if (this.editionBlock.isVisible()) {
            this.refreshEdition();
        } else if (this.previewBlock.isVisible()) {
            this.refreshPreview();
        } else if (this.indexBlock.isVisible()) {
            this.refreshIndex();
        }
    }

    private void initToolbar() {
        this.previousStep.onExecute(e -> {
            this.previousStep();
            if (!this.editionBlock.isVisible()) {
                this.viewSelector.select("editionOption");
            }
        });
        this.nextStep.onExecute(e -> this.continueStep(this.current));
        this.restartOrder.onExecute(e -> this.reset());
        this.terminateOrder.onExecute(e -> this.notifyComplete());
    }

    private void continueStep(Field field) {
        Edition edition = field.edition();
        this.setValueIfEmpty(field);
        if (edition.isOptional() && (edition.isEmpty() || edition.isNull())) {
            this.skip(field);
        } else {
            this.nextStep();
        }
        if (!this.editionBlock.isVisible()) {
            this.viewSelector.select("editionOption");
        }
    }

    private void setValueIfEmpty(Field field) {
        this.setNumberValueIfEmpty(field);
        this.setMultiOptionValueIfEmpty(field);
        this.setDateValueIfEmpty(field);
        this.setSectionValueIfEmpty(field);
    }

    private void setNumberValueIfEmpty(Field field) {
        if (field.type() != FieldType.Number) {
            return;
        }
        NumberEdition edition = (NumberEdition)field.edition().as(NumberEdition.class);
        if (edition.isEmpty() || edition.isNull()) {
            edition.set(edition.min());
        }
    }

    private void setMultiOptionValueIfEmpty(Field field) {
        if (field.type() != FieldType.MultiOption) {
            return;
        }
        OptionMultipleEdition edition = (OptionMultipleEdition)field.edition().as(OptionMultipleEdition.class);
        if (edition.isEmpty() || edition.isNull()) {
            edition.set(new String[0]);
        }
    }

    private void setDateValueIfEmpty(Field field) {
        if (field.type() != FieldType.Date) {
            return;
        }
        DateEdition edition = (DateEdition)field.edition().as(DateEdition.class);
        if (edition.isEmpty() || edition.isNull()) {
            edition.set(LocalDate.now());
        }
    }

    private void setSectionValueIfEmpty(Field field) {
        if (field.type() != FieldType.Section && field.type() != FieldType.Marker) {
            return;
        }
        SectionEdition edition = (SectionEdition)field.edition().as(SectionEdition.class);
        if (edition.isEmpty() || edition.isNull()) {
            edition.set();
        }
    }

    private void previousStep() {
        if (this.current == null) {
            this.current = this.previous;
        } else if (this.current.hasPrev()) {
            this.current = this.current.prev();
        }
        this.renderWizardStep();
    }

    private void nextStep() {
        this.previous = this.current;
        this.current = this.current.hasNext() ? this.current.next() : null;
        this.applyFormula(this.current);
        this.renderWizardStep();
    }

    private void renderWizardStep() {
        this.editionBlock.finalBlock.visible(this.current == null);
        this.editionBlock.stepBlock.visible(this.current != null);
        this.refreshStepDisplay(this.current);
        this.refreshState(this.current);
    }

    private void refreshStepDisplay(Field field) {
        if (field == null) {
            return;
        }
        this.editionBlock.stepBlock.stepStamp.order(this.order);
        this.editionBlock.stepBlock.stepStamp.form(this.form);
        this.editionBlock.stepBlock.stepStamp.field(field);
        this.editionBlock.stepBlock.stepStamp.refresh();
    }

    private void skip(Field field) {
        field.edition().skip();
        this.nextStep();
    }

    private void refreshStateAndSave(Field field) {
        this.refreshState(field);
        this.save();
    }

    private void refreshState(Field field) {
        this.refreshProgress();
        this.restartOrder.readonly(this.form.progress() <= 0);
        this.previousStep.readonly(field != null && !field.hasPrev());
        this.nextStep.readonly(field == null || !this.isFilled(field));
        this.terminateOrder.readonly(!this.form.isCompleted());
    }

    private boolean isFilled(Field field) {
        Edition edition = field.edition();
        if (edition.isOptional()) {
            return true;
        }
        if (field.type() == FieldType.Date) {
            return true;
        }
        if (field.type() == FieldType.Number) {
            return true;
        }
        if (field.type() == FieldType.MultiOption) {
            return true;
        }
        return !edition.isEmpty() && !edition.isNull();
    }

    private void initEdition() {
        this.editionBlock.stepBlock.stepStamp.onChange(this::refreshStateAndSave);
        this.editionBlock.stepBlock.stepStamp.onSkip(this::skip);
        this.editionBlock.stepBlock.stepStamp.onContinue(this::continueStep);
        this.editionBlock.finalBlock.viewIndex.onExecute(e -> this.viewSelector.select("indexOption"));
        this.editionBlock.finalBlock.viewWorkReport.onExecute(e -> this.viewSelector.select("previewOption"));
    }

    private void refreshEdition() {
        OrderTypes.Record record = OrderTypes.of((String)this.order.code());
        this.editionBlock.orderInfo.value(record != null ? OrderHelper.replaceInputs(this.order, record.hint(this.language())) : null);
        this.editionBlock.orderInfo.visible(this.editionBlock.orderInfo.value() != null && !this.editionBlock.orderInfo.value().isEmpty());
        this.renderWizardStep();
        this.removePreview();
    }

    private void refreshPreview() {
        this.removePreview();
        this.previewBlock.workReportPreview.value(this.previewReport());
        this.refreshState(this.current);
    }

    private void removePreview() {
        try {
            if (this.previewBlock.workReportPreview == null) {
                return;
            }
            URL value = this.previewBlock.workReportPreview.value();
            if (value == null) {
                return;
            }
            File file = new File(value.toURI());
            if (!file.exists()) {
                return;
            }
            file.delete();
        }
        catch (URISyntaxException e) {
            Logger.error((Throwable)e);
        }
    }

    private void refreshIndex() {
        this.generatingMessage.visible(true);
        this.indexBlock.indexEntriesBlock.hide();
        this.indexBlock.indexEntriesBlock.indexEntries.clear();
        this.form.editions(new FieldType[0]).stream().filter(e -> !e.isHidden() && !e.isDisabled()).forEach(e -> this.fill((Edition)e, (CheckListWizardIndexEntry)this.indexBlock.indexEntriesBlock.indexEntries.add()));
        this.generatingMessage.visible(false);
        this.indexBlock.indexEntriesBlock.show();
        this.refreshState(this.current);
        this.removePreview();
    }

    private void fill(Edition edition, CheckListWizardIndexEntry display) {
        display.form(this.form);
        display.edition(edition);
        display.onSelect(e -> this.selectStep(e.name()));
        display.refresh();
    }

    private void selectStep(String name) {
        this.current = this.form.field(name);
        this.viewSelector.select("editionOption");
    }

    private void notifyComplete() {
        this.save();
        this.terminateOrder.disable();
        File report = this.resolveOrder();
        if (report == null) {
            this.terminateOrder.enable();
            return;
        }
        if (this.completeListener != null) {
            this.completeListener.accept(report, this.form);
        }
        ((OrderTemplateNotifier)this.notifier).finish();
        this.removePreview();
        this.removeStore();
        this.showOrderCompleted();
    }

    private void removeStore() {
        if (this.order.isStoreDefined()) {
            return;
        }
        this.reset();
    }

    private File resolveOrder() {
        this.generatingMessage.visible(true);
        OrderCommands commands = ((MonetBox)this.box()).commands(OrderCommands.class);
        if (!commands.canResolve(this.order, this.form, this.author())) {
            this.notifyUser(this.translate("Could not resolve order. Check parameters."), UserMessage.Type.Error);
            return null;
        }
        File result = commands.resolve(this.order, this.form, this.testEnvironment, this.language(), this.author());
        if (result == null) {
            this.notifyUser(this.translate("Could not resolve order"), UserMessage.Type.Error);
        }
        this.generatingMessage.visible(false);
        return result;
    }

    private void showOrderCompleted() {
        this.orderFoundBlock.visible(false);
        this.orderCompletedBlock.visible(true);
    }

    private File previewReport() {
        this.generatingMessage.visible(true);
        OrderCommands commands = ((MonetBox)this.box()).commands(OrderCommands.class);
        if (!commands.canResolve(this.order, this.form, this.author())) {
            this.notifyUser(this.translate("Could not preview order. Check parameters."), UserMessage.Type.Error);
            return null;
        }
        File result = commands.preview(this.order, this.form, this.language(), this.author());
        if (result == null) {
            this.notifyUser(this.translate("Could not resolve order"), UserMessage.Type.Error);
        }
        this.generatingMessage.visible(false);
        return result;
    }

    private String author() {
        return this.author != null ? this.author : this.username();
    }

    private FormDefinition formDefinition() {
        return FormHelper.formDefinition((MonetBox)this.box(), this.order);
    }

    private FormStore store() {
        File directory = ((MonetBox)this.box()).archetype().repository().workorders().getStoreDirectory(this.order.store());
        LocalFormStore result = new LocalFormStore(directory);
        try {
            result.load();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fillInputs(result);
        return result;
    }

    private void fillInputs(LocalFormStore result) {
        this.order.inputMap().forEach((arg_0, arg_1) -> ((LocalFormStore)result).put(arg_0, arg_1));
    }

    private void refreshResolveOrderDialog() {
        this.progress.clear();
        this.viewSelector.select("editionOption");
    }

    private void save() {
        try {
            ((LocalFormStore)this.form.store).save();
            this.notifySaved();
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    public void reset() {
        try {
            File storeDir = ((MonetBox)this.box()).archetype().repository().workorders().getStoreDirectory(this.order.store());
            if (storeDir.exists()) {
                FileUtils.deleteDirectory((File)storeDir);
            }
            this.form = new Form(this.formDefinition(), this.store());
            this.createFormulaCalculator();
            this.current = this.form.start(Language.valueOf((String)this.language()));
            this.refresh();
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private void notifySaved() {
        this.savedMessage.visible(true);
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                OrderTemplate.this.hideSavedNotification();
            }
        }, 3000L);
    }

    private void hideSavedNotification() {
        this.savedMessage.visible(false);
    }

    private void refreshProgress() {
        ProgressDisplay display = this.progress.display() != null ? (ProgressDisplay)this.progress.display() : this.createProgress();
        display.value(this.form.progress(), this.progressLabel());
        display.refresh();
    }

    private String progressLabel() {
        return null;
    }

    private ProgressDisplay createProgress() {
        ProgressDisplay display = new ProgressDisplay((MonetBox)this.box());
        this.progress.display(display);
        return display;
    }

    private void createFormulaCalculator() {
        try {
            if (this.order == null) {
                return;
            }
            File template = WorkReportHelper.calculationTemplate(WorkReportGenerator.Archetype.OrderTypes.wrap(((MonetBox)this.box()).archetype().definitions().orderTypes()), this.order);
            if (!template.exists()) {
                return;
            }
            this.formulaCalculator = new WorkReportCalculator(template, OrderHelper.valuesOf(this.order, this.form));
            this.applyFormula();
        }
        catch (IOException | InvalidFormatException e) {
            Logger.error((Throwable)e);
        }
    }

    private void applyFormula(Field field) {
        if (field == null || this.formulaCalculator == null) {
            return;
        }
        this.formulaCalculator.map(OrderHelper.valuesOf(this.order, this.form));
        Map<String, String> values = this.formulaCalculator.update(field.name(), FormHelper.valueOf(field.edition()));
        this.nonFieldValues(values).forEach(e -> this.form.store.put((String)e.getKey(), e.getValue()));
    }

    private void applyFormula() {
        if (this.formulaCalculator == null) {
            return;
        }
        Map<String, String> values = this.formulaCalculator.update();
        this.nonFieldValues(values).forEach(e -> this.form.store.put((String)e.getKey(), e.getValue()));
    }

    private Stream<Map.Entry<String, String>> nonFieldValues(Map<String, String> values) {
        return values.entrySet().stream().filter(e -> !this.isField((String)e.getKey()));
    }

    private boolean isField(String key) {
        return this.form.definition.fields().stream().anyMatch(f -> f.name.equalsIgnoreCase(key));
    }
}

