/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.box.ui.displays.templates;

import io.intino.alexandria.Resource;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.displays.components.Text;
import io.intino.alexandria.ui.displays.components.TextCode;
import io.intino.monet.box.MonetBox;
import io.intino.monet.box.ui.displays.AttachmentRenderer;
import io.intino.monet.box.ui.displays.templates.AbstractCheckListWizardStep;
import io.intino.monet.box.ui.displays.templates.CheckListWizardStepPackageFile;
import io.intino.monet.box.util.Formatters;
import io.intino.monet.box.util.OrderHelper;
import io.intino.monet.box.util.SearchHelper;
import io.intino.monet.engine.Order;
import io.intino.monet.engine.edition.Field;
import io.intino.monet.engine.edition.FieldType;
import io.intino.monet.engine.edition.Form;
import io.intino.monet.engine.edition.editors.DateEdition;
import io.intino.monet.engine.edition.editors.ImageEdition;
import io.intino.monet.engine.edition.editors.NoteEdition;
import io.intino.monet.engine.edition.editors.NumberEdition;
import io.intino.monet.engine.edition.editors.OptionEdition;
import io.intino.monet.engine.edition.editors.OptionMultipleEdition;
import io.intino.monet.engine.edition.editors.PackageEdition;
import io.intino.monet.engine.edition.editors.SectionEdition;
import io.intino.monet.engine.edition.editors.SignatureEdition;
import io.intino.monet.engine.edition.editors.StringEdition;
import io.intino.monet.engine.edition.editors.ValidationEdition;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class CheckListWizardStep
extends AbstractCheckListWizardStep<MonetBox> {
    private Order order;
    private Form form;
    private Field field;
    private Consumer<Field> changeListener;
    private Consumer<Field> skipListener;
    private Consumer<Field> continueListener;

    public CheckListWizardStep(Box box) {
        super((MonetBox)box);
    }

    public CheckListWizardStep order(Order order) {
        this.order = order;
        return this;
    }

    public CheckListWizardStep form(Form form) {
        this.form = form;
        return this;
    }

    public CheckListWizardStep field(Field field) {
        this.field = field;
        return this;
    }

    public CheckListWizardStep onChange(Consumer<Field> listener) {
        this.changeListener = listener;
        return this;
    }

    public CheckListWizardStep onSkip(Consumer<Field> listener) {
        this.skipListener = listener;
        return this;
    }

    public CheckListWizardStep onContinue(Consumer<Field> listener) {
        this.continueListener = listener;
        return this;
    }

    public Object value() {
        return this.field.edition().value();
    }

    @Override
    public void init() {
        super.init();
        this.textField.onChange(e -> this.updateText((String)e.value()));
        this.textField.onEnterPress(e -> this.updateTextAndContinue((String)e.value()));
        this.numberField.onChange(e -> this.updateNumber((Double)e.value()));
        this.dateField.onChange(e -> this.updateDate((Instant)e.value()));
        this.optionField.onSelect(e -> this.updateOption(e.selection()));
        this.optionFieldSearch.onChange(e -> this.filterOptions((String)e.value()));
        this.optionFieldSearch.onEnterPress(e -> this.filterOptions((String)e.value()));
        this.multiOptionField.onSelect(e -> this.updateMultiOption(e.selection()));
        this.acceptValidation.onExecute(e -> this.acceptValidation());
        this.rejectValidation.onExecute(e -> this.rejectValidation());
        this.noteField.onChange(e -> this.updateNote(e.value()));
        this.notePhotoField.onChange(e -> this.updateNotePhoto(e.value()));
        this.photoField.onChange(e -> this.updatePhoto(e.value()));
        this.photoLabelField.onChange(e -> this.updatePhotoLabel(e.value()));
        this.signatureField.onChange(e -> this.updateSignature(e.value()));
        this.skipStep.onExecute(e -> this.skip());
        this.optionalSkipSection.onExecute(e -> this.skip());
        this.optionalContinueSection.onExecute(e -> this.continueSection());
        this.continueSection.onExecute(e -> this.continueSection());
        this.packageFieldAdd.onExecute(e -> this.addPackage());
    }

    private void skip() {
        this.skipListener.accept(this.field);
    }

    private void addFileToPackage(int index, Object item) {
        if (item == null) {
            this.removeFileFromPackage(index);
            return;
        }
        PackageEdition.Package packageValue = ((PackageEdition)this.field.edition().as(PackageEdition.class)).get();
        Resource resource = (Resource)item;
        packageValue.add(resource.name(), resource.stream());
        this.refreshPackageField();
        this.notifyChange(this.field);
    }

    private void removeFileFromPackage(int index) {
        PackageEdition.Package packageValue = ((PackageEdition)this.field.edition().as(PackageEdition.class)).get();
        List files = packageValue.files();
        if (files.size() <= index) {
            return;
        }
        File file = (File)files.get(index);
        file.delete();
        this.refreshPackageField();
        this.notifyChange(this.field);
    }

    private void updateText(String value) {
        if (!(this.field.edition() instanceof StringEdition)) {
            return;
        }
        StringEdition edition = (StringEdition)this.field.edition().as(StringEdition.class);
        edition.set(this.format(value));
        this.notifyChange(this.field);
    }

    private void updateTextAndContinue(String value) {
        this.updateText(value);
        this.continueListener.accept(this.field);
    }

    private void updateNumber(Double value) {
        if (!(this.field.edition() instanceof NumberEdition)) {
            return;
        }
        NumberEdition edition = (NumberEdition)this.field.edition().as(NumberEdition.class);
        edition.set(value.doubleValue());
        this.notifyChange(this.field);
    }

    private void updateDate(Instant value) {
        if (!(this.field.edition() instanceof DateEdition)) {
            return;
        }
        DateEdition edition = (DateEdition)this.field.edition().as(DateEdition.class);
        edition.set(LocalDate.ofInstant(value, ZoneId.of("UTC")));
        this.notifyChange(this.field);
    }

    private void updateOption(List<String> selection) {
        if (!(this.field.edition() instanceof OptionEdition)) {
            return;
        }
        OptionEdition edition = (OptionEdition)this.field.edition().as(OptionEdition.class);
        edition.set(selection.size() > 0 ? selection.get(0) : null);
        this.notifyChange(this.field);
        this.continueListener.accept(this.field);
    }

    private void filterOptions(String value) {
        if (!(this.field.edition() instanceof OptionEdition)) {
            return;
        }
        OptionEdition edition = (OptionEdition)this.field.edition().as(OptionEdition.class);
        this.optionField.clear();
        this.optionField.addAll(SearchHelper.filter((List<String>)edition.options(), value));
    }

    private void updateMultiOption(List<String> selection) {
        if (!(this.field.edition() instanceof OptionMultipleEdition)) {
            return;
        }
        OptionMultipleEdition edition = (OptionMultipleEdition)this.field.edition().as(OptionMultipleEdition.class);
        List options = edition.options();
        edition.set((String[])selection.stream().filter(options::contains).toArray(String[]::new));
        this.notifyChange(this.field);
    }

    private void acceptValidation() {
        if (!(this.field.edition() instanceof ValidationEdition)) {
            return;
        }
        ValidationEdition edition = (ValidationEdition)this.field.edition().as(ValidationEdition.class);
        edition.set((String)edition.options().get(0));
        this.notifyChange(this.field);
        this.continueListener.accept(this.field);
    }

    private void rejectValidation() {
        if (!(this.field.edition() instanceof ValidationEdition)) {
            return;
        }
        ValidationEdition edition = (ValidationEdition)this.field.edition().as(ValidationEdition.class);
        edition.set((String)edition.options().get(1));
        this.notifyChange(this.field);
        this.continueListener.accept(this.field);
    }

    private void updatePhoto(Object value) {
        try {
            if (!(this.field.edition() instanceof ImageEdition)) {
                return;
            }
            URL image = this.urlOf(value);
            ImageEdition edition = (ImageEdition)this.field.edition().as(ImageEdition.class);
            edition.set(image != null ? Paths.get(image.toURI()).toFile() : null, this.photoLabelField.value());
            this.photoField.value(edition.get() != null ? edition.get().file : null);
            this.notifyChange(this.field);
        }
        catch (URISyntaxException e) {
            Logger.error((Throwable)e);
        }
    }

    private void updatePhotoLabel(Object value) {
        ImageEdition edition;
        if (!(this.field.edition() instanceof ImageEdition)) {
            return;
        }
        ImageEdition.Image image = (edition = (ImageEdition)this.field.edition().as(ImageEdition.class)).get();
        edition.set(image != null ? image.file : null, this.format(this.photoLabelField.value()));
        this.notifyChange(this.field);
    }

    private void updateSignature(Object value) {
        try {
            if (!(this.field.edition() instanceof SignatureEdition)) {
                return;
            }
            URL signature = this.urlOf(value);
            SignatureEdition edition = (SignatureEdition)this.field.edition().as(SignatureEdition.class);
            edition.set(signature != null ? Paths.get(signature.toURI()).toFile() : null);
            this.signatureField.value(edition.get() != null ? edition.get().file : null);
            this.notifyChange(this.field);
        }
        catch (URISyntaxException e) {
            Logger.error((Throwable)e);
        }
    }

    private void updateNote(Object value) {
        if (!(this.field.edition() instanceof NoteEdition)) {
            return;
        }
        NoteEdition edition = (NoteEdition)this.field.edition().as(NoteEdition.class);
        edition.set(this.format(this.noteField.value()));
        this.notifyChange(this.field);
    }

    private void updateNotePhoto(Object value) {
        try {
            if (!(this.field.edition() instanceof NoteEdition)) {
                return;
            }
            URL image = this.urlOf(value);
            NoteEdition edition = (NoteEdition)this.field.edition().as(NoteEdition.class);
            edition.set(this.noteField.value(), image != null ? Paths.get(image.toURI()).toFile() : null);
            this.notePhotoField.value(edition.get() != null ? edition.get().file : null);
            this.notifyChange(this.field);
        }
        catch (URISyntaxException e) {
            Logger.error((Throwable)e);
        }
    }

    private void continueSection() {
        if (!(this.field.edition() instanceof SectionEdition)) {
            return;
        }
        SectionEdition edition = (SectionEdition)this.field.edition().as(SectionEdition.class);
        edition.set();
        this.continueListener.accept(this.field);
    }

    private URL urlOf(Object value) {
        if (this.field.type() == FieldType.Image && value == null) {
            return null;
        }
        if (this.field.type() == FieldType.Signature && value == null) {
            return null;
        }
        if (!(value instanceof Resource)) {
            return null;
        }
        Resource resource = (Resource)value;
        return this.urlOf(value, this.username() + "_" + this.field.name().replace(" ", "") + this.extensionOf(resource.name()));
    }

    private URL urlOf(Object value, String name) {
        try {
            if (this.field.type() == FieldType.Image && value == null) {
                return null;
            }
            if (this.field.type() == FieldType.Signature && value == null) {
                return null;
            }
            if (!(value instanceof Resource)) {
                return null;
            }
            Resource resource = (Resource)value;
            File image = new File(System.getProperty("java.io.tmpdir") + "/" + name);
            Files.write(image.toPath(), resource.bytes(), StandardOpenOption.CREATE);
            try {
                resource.stream().reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return image.toURI().toURL();
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    private String extensionOf(String name) {
        if (!name.contains(".")) {
            return name;
        }
        return name.substring(name.lastIndexOf("."));
    }

    private void notifyChange(Object value) {
        this.changeListener.accept(this.field);
    }

    public void refresh() {
        super.refresh();
        this.skipStep.visible(this.field.edition().isOptional());
        this.refreshHeader(this.title, this.info);
        this.refreshAttachmentDialog();
        this.refreshEdition();
    }

    private void refreshAttachmentDialog() {
        File attachment = this.field.edition().attachment();
        boolean existAttachment = attachment != null && attachment.exists();
        this.attachmentStamp.visible(existAttachment);
        if (!existAttachment) {
            return;
        }
        AttachmentRenderer display = new AttachmentRenderer((MonetBox)this.box());
        this.attachmentStamp.display(display);
        display.order(this.order);
        display.form(this.form);
        display.field(this.field);
        display.attachment(this.field.edition().attachment());
        display.refresh();
    }

    private void refreshEdition() {
        this.refreshSectionField();
        this.refreshOtherFields();
    }

    private void refreshSectionField() {
        this.sectionStepFields.visible(this.field.type() == FieldType.Section || this.field.type() == FieldType.Marker);
        if (!this.sectionStepFields.isVisible()) {
            return;
        }
        boolean optional = this.field.edition().isOptional();
        this.refreshHeader(this.sectionTitle, this.sectionInfo);
        this.optionalSectionBlock.visible(optional);
        this.defaultSectionBlock.visible(!optional);
    }

    private void refreshOtherFields() {
        this.otherStepFields.visible(this.field.type() != FieldType.Section && this.field.type() != FieldType.Marker);
        if (!this.otherStepFields.isVisible()) {
            return;
        }
        this.refreshPhotoField();
        this.refreshSignatureField();
        this.refreshNoteField();
        this.refreshRemarkField();
        this.refreshPackageField();
        this.refreshDateField();
        this.refreshTextField();
        this.refreshOptionField();
        this.refreshMultiOptionField();
        this.refreshValidationField();
        this.refreshNumberField();
    }

    private void refreshPhotoField() {
        try {
            this.photoFieldBlock.visible(this.field.type() == FieldType.Image);
            if (!this.photoFieldBlock.isVisible()) {
                return;
            }
            ImageEdition imageEdition = (ImageEdition)this.field.edition().as(ImageEdition.class);
            ImageEdition.Image photo = imageEdition.get();
            this.photoField.value(photo != null && photo.file != null ? photo.file.toURI().toURL() : null);
            this.photoLabelField.value(!imageEdition.isEmpty() && photo != null ? photo.label.trim() : null);
        }
        catch (MalformedURLException e) {
            Logger.error((Throwable)e);
        }
    }

    private void refreshSignatureField() {
        try {
            this.signatureFieldBlock.visible(this.field.type() == FieldType.Signature);
            if (!this.signatureFieldBlock.isVisible()) {
                return;
            }
            SignatureEdition signatureEdition = (SignatureEdition)this.field.edition().as(SignatureEdition.class);
            SignatureEdition.Signature signature = signatureEdition.get();
            this.signatureField.value(signature != null && signature.file != null ? signature.file.toURI().toURL() : null);
        }
        catch (MalformedURLException e) {
            Logger.error((Throwable)e);
        }
    }

    private void refreshNoteField() {
        try {
            this.noteFieldBlock.visible(this.field.type() == FieldType.Note);
            if (!this.noteFieldBlock.isVisible()) {
                return;
            }
            NoteEdition edition = (NoteEdition)this.field.edition().as(NoteEdition.class);
            NoteEdition.Note note = edition.get();
            this.noteField.value(!edition.isEmpty() && note != null ? note.label.replace("<br/>", "\n") : null);
            this.notePhotoField.value(note != null && note.file != null ? note.file.toURI().toURL() : null);
        }
        catch (MalformedURLException e) {
            Logger.error((Throwable)e);
        }
    }

    private void refreshRemarkField() {
    }

    private void refreshPackageField() {
        this.packageFieldBlock.visible(this.field.type() == FieldType.Package);
        if (!this.packageFieldBlock.isVisible()) {
            return;
        }
        this.packageField.clear();
        PackageEdition edition = (PackageEdition)this.field.edition().as(PackageEdition.class);
        edition.set();
        PackageEdition.Package packageData = edition.get();
        List files = packageData.files();
        for (int i = 0; i < files.size(); ++i) {
            this.fill((File)files.get(i), i, (CheckListWizardStepPackageFile)this.packageField.add());
        }
    }

    private void fill(File file, int index, CheckListWizardStepPackageFile display) {
        try {
            display.value(file != null ? file.toURI().toURL() : null);
            display.onChange((Resource value) -> this.addFileToPackage(index, value));
            display.refresh();
        }
        catch (MalformedURLException e) {
            Logger.error((Throwable)e);
        }
    }

    private void addPackage() {
        if (!(this.field.edition() instanceof PackageEdition)) {
            return;
        }
        this.fill(null, ((PackageEdition)this.field.edition().as(PackageEdition.class)).get().files().size(), (CheckListWizardStepPackageFile)this.packageField.add());
    }

    private void refreshDateField() {
        this.dateField.visible(this.field.type() == FieldType.Date);
        if (!this.dateField.isVisible()) {
            return;
        }
        DateEdition edition = (DateEdition)this.field.edition().as(DateEdition.class);
        this.dateField.value(!edition.isEmpty() ? Formatters.instantOf(edition.get()) : null);
        if (edition.mode() == DateEdition.Mode.Future) {
            this.dateField.range(Instant.now(), null);
        } else if (edition.mode() == DateEdition.Mode.Past) {
            this.dateField.range(null, Instant.now());
        }
    }

    private void refreshTextField() {
        this.textField.visible(this.field.type() == FieldType.String);
        if (!this.textField.isVisible()) {
            return;
        }
        StringEdition edition = (StringEdition)this.field.edition().as(StringEdition.class);
        this.textField.value(!edition.isEmpty() ? edition.get() : null);
    }

    private void refreshOptionField() {
        String selected;
        this.optionFieldBlock.visible(false);
        if (this.field.type() != FieldType.Option) {
            return;
        }
        OptionEdition edition = (OptionEdition)this.field.edition().as(OptionEdition.class);
        List options = edition.options();
        this.optionFieldSearch.value(null);
        this.optionFieldSearch.visible(options.size() > 5);
        this.optionField.clear();
        this.optionField.addAll(options);
        String string = selected = !edition.isEmpty() ? edition.get() : null;
        if (selected != null) {
            this.optionField.selection(new String[]{selected});
        } else {
            this.optionField.selection(Collections.emptyList());
        }
        this.selectedOptionField.value(selected);
        this.optionFieldBlock.visible(true);
    }

    private void refreshMultiOptionField() {
        this.multiOptionField.visible(this.field.type() == FieldType.MultiOption);
        if (!this.multiOptionField.visible()) {
            return;
        }
        OptionMultipleEdition edition = (OptionMultipleEdition)this.field.edition().as(OptionMultipleEdition.class);
        List options = edition.options();
        this.multiOptionField.clear();
        this.multiOptionField.addAll(options);
        this.multiOptionField.readonly(options.size() <= 0);
        List<String> selection = Arrays.asList(edition.get());
        this.multiOptionField.selection(selection.stream().filter(options::contains).collect(Collectors.toList()));
    }

    private void refreshValidationField() {
        this.validationFieldBlock.visible(false);
        if (this.field.type() != FieldType.Validation) {
            return;
        }
        ValidationEdition edition = (ValidationEdition)this.field.edition().as(ValidationEdition.class);
        List options = edition.options();
        this.acceptValidation.title((String)options.get(0));
        this.rejectValidation.title((String)options.get(1));
        this.validationFieldBlock.visible(true);
    }

    private void refreshNumberField() {
        this.numberField.visible(this.field.type() == FieldType.Number);
        if (!this.numberField.isVisible()) {
            return;
        }
        NumberEdition edition = (NumberEdition)this.field.edition().as(NumberEdition.class);
        this.numberField.value(!edition.isEmpty() ? Double.valueOf(edition.get()) : null);
        this.numberField.range(edition.min(), edition.max());
    }

    private void refreshHeader(Text<?, ?> title, TextCode<?, ?> info) {
        String description = OrderHelper.replaceInputs(this.order, this.field.description());
        String header = OrderHelper.replaceInputs(this.order, this.field.header());
        title.value((String)(header != null && !header.isEmpty() ? header + ": " : "") + this.field.title());
        info.visible(!description.isEmpty());
        if (info.isVisible()) {
            info.value(description);
        }
    }

    private String format(String value) {
        if (value == null) {
            return value;
        }
        return value.replace("\n", "<br/>").replace("\t", "").trim();
    }
}

