/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.components.BlockConditional;
import io.intino.monet.box.MonetBox;
import io.intino.monet.box.ui.displays.templates.AbstractAppTemplate;
import java.util.Arrays;

public class AppTemplate
extends AbstractAppTemplate<MonetBox> {
    private Page current = null;
    private boolean embedded = false;

    public AppTemplate(MonetBox box) {
        super(box);
    }

    public void embedded(boolean embedded) {
        if (!embedded) {
            return;
        }
        this.header.embedded(true);
        this.embedded = embedded;
    }

    public void openHome() {
        this.openOrderTypes();
    }

    public void openOrderTypes() {
        this.openPage(Page.OrderTypes);
        if (this.orderTypesPage.orderTypesStamp != null) {
            this.orderTypesPage.orderTypesStamp.refresh();
        }
    }

    public void openOrder(String id) {
        this.openPage(Page.Order);
        if (this.orderPage.orderStamp != null) {
            this.orderPage.orderStamp.open(id);
        }
    }

    public void refresh() {
        super.refresh();
        this.refreshCurrentPage();
    }

    private boolean openPage(Page page) {
        if (page == this.current) {
            return false;
        }
        this.loading.visible(false);
        this.header.refresh();
        this.hideBlocks();
        this.blockOf(page).show();
        this.current = page;
        return true;
    }

    private void hideBlocks() {
        if (this.orderTypesPage.isVisible()) {
            this.orderTypesPage.hide();
        }
        if (this.orderPage.isVisible()) {
            this.orderPage.hide();
        }
    }

    private BlockConditional blockOf(Page page) {
        if (page == Page.OrderTypes) {
            return this.orderTypesPage;
        }
        if (page == Page.Order) {
            return this.orderPage;
        }
        return null;
    }

    private void refreshCurrentPage() {
        if (this.current == Page.OrderTypes) {
            this.orderTypesPage.orderTypesStamp.refresh();
        } else if (this.current == Page.Order) {
            this.orderPage.orderStamp.refresh();
        }
    }

    public static enum Page {
        OrderTypes,
        Order;


        public static Page from(String key) {
            return Arrays.stream(Page.values()).filter(v -> v.name().equalsIgnoreCase(key)).findFirst().orElse(null);
        }
    }
}

