/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.box.ui;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.http.spark.PushService;
import io.intino.alexandria.ui.UI;
import io.intino.alexandria.ui.UISpark;
import io.intino.alexandria.ui.displays.DisplayRouteDispatcher;
import io.intino.alexandria.ui.displays.notifiers.ItemNotifier;
import io.intino.alexandria.ui.displays.notifiers.TemplateNotifier;
import io.intino.alexandria.ui.displays.requesters.DisplayPushRequester;
import io.intino.alexandria.ui.displays.requesters.ItemPushRequester;
import io.intino.alexandria.ui.displays.requesters.ItemRequester;
import io.intino.alexandria.ui.displays.requesters.TemplatePushRequester;
import io.intino.alexandria.ui.displays.requesters.TemplateRequester;
import io.intino.alexandria.ui.resources.AssetResourceLoader;
import io.intino.alexandria.ui.spark.UIRouter;
import io.intino.alexandria.ui.spark.UISparkManager;
import io.intino.alexandria.ui.spark.resources.AfterDisplayRequest;
import io.intino.alexandria.ui.spark.resources.AssetResource;
import io.intino.alexandria.ui.spark.resources.AuthenticateCallbackResource;
import io.intino.alexandria.ui.spark.resources.BeforeDisplayRequest;
import io.intino.monet.box.MonetBox;
import io.intino.monet.box.MonetConfiguration;
import io.intino.monet.box.ui.displays.AttachmentRenderer;
import io.intino.monet.box.ui.displays.ProgressDisplay;
import io.intino.monet.box.ui.displays.items.OrderTypeItem;
import io.intino.monet.box.ui.displays.notifiers.AttachmentRendererNotifier;
import io.intino.monet.box.ui.displays.notifiers.OrderTemplateNotifier;
import io.intino.monet.box.ui.displays.notifiers.OrderTemplateProxyNotifier;
import io.intino.monet.box.ui.displays.notifiers.ProgressDisplayNotifier;
import io.intino.monet.box.ui.displays.requesters.AttachmentRendererPushRequester;
import io.intino.monet.box.ui.displays.requesters.AttachmentRendererRequester;
import io.intino.monet.box.ui.displays.requesters.OrderTemplateProxyRequester;
import io.intino.monet.box.ui.displays.requesters.ProgressDisplayPushRequester;
import io.intino.monet.box.ui.displays.requesters.ProgressDisplayRequester;
import io.intino.monet.box.ui.displays.templates.AppTemplate;
import io.intino.monet.box.ui.displays.templates.CheckListWizardIndexEntry;
import io.intino.monet.box.ui.displays.templates.CheckListWizardStep;
import io.intino.monet.box.ui.displays.templates.CheckListWizardStepPackageFile;
import io.intino.monet.box.ui.displays.templates.Header;
import io.intino.monet.box.ui.displays.templates.OrderInputEditor;
import io.intino.monet.box.ui.displays.templates.OrderTemplate;
import io.intino.monet.box.ui.displays.templates.OrderTemplateProxy;
import io.intino.monet.box.ui.displays.templates.OrderTypesTemplate;
import io.intino.monet.box.ui.resources.HomeResource;
import io.intino.monet.box.ui.resources.OrderPageResource;
import io.intino.monet.box.ui.resources.OrderTemplateProxyResource;

public class MonetElementsService
extends UI {
    public static void init(UISpark spark, MonetBox box, io.intino.alexandria.ui.services.push.PushService pushService, DisplayRouteDispatcher routeDispatcher) {
        MonetConfiguration configuration = box.configuration();
        box.routeManager(MonetElementsService.routeManager((UISpark)spark, (DisplayRouteDispatcher)routeDispatcher));
        ((UIRouter)spark.route("/push")).push((PushService)pushService);
        ((UIRouter)spark.route("/authenticate-callback")).get(manager -> new AuthenticateCallbackResource(manager, MonetElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/authenticate-callback/")).get(manager -> new AuthenticateCallbackResource(manager, MonetElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/asset/:name")).get(manager -> new AssetResource(name -> new AssetResourceLoader((Box)box).load(name), manager, MonetElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/alexandria/user")).get(manager -> new HomeResource(box, (UISparkManager)manager, MonetElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/")).get(manager -> new HomeResource(box, (UISparkManager)manager, MonetElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/order/:id")).get(manager -> new OrderPageResource(box, (UISparkManager)manager, MonetElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/ordertemplateproxy/:displayId/personify")).post(manager -> new OrderTemplateProxyResource(box, (UISparkManager)manager, MonetElementsService.notifierProvider()).execute());
        MonetElementsService.initDisplays(spark, pushService);
    }

    public static void initDisplays(UISpark spark, io.intino.alexandria.ui.services.push.PushService pushService) {
        MonetElementsService.initOrderTypesTemplate(spark, pushService);
        MonetElementsService.initOrderTemplate(spark, pushService);
        MonetElementsService.initOrderInputEditor(spark, pushService);
        MonetElementsService.initCheckListWizardStep(spark, pushService);
        MonetElementsService.initCheckListWizardIndexEntry(spark, pushService);
        MonetElementsService.initCheckListWizardStepPackageFile(spark, pushService);
        MonetElementsService.initProgressDisplay(spark, pushService);
        MonetElementsService.initAttachmentRenderer(spark, pushService);
        MonetElementsService.initAppTemplate(spark, pushService);
        MonetElementsService.initHeader(spark, pushService);
        MonetElementsService.initOrderTypeItem(spark, pushService);
        MonetElementsService.registerNotifiers();
    }

    private static void registerNotifiers() {
        MonetElementsService.register(TemplateNotifier.class).forDisplay(OrderTypesTemplate.class);
        MonetElementsService.register(OrderTemplateNotifier.class).forDisplay(OrderTemplate.class);
        MonetElementsService.register(OrderTemplateProxyNotifier.class).forDisplay(OrderTemplateProxy.class);
        MonetElementsService.register(TemplateNotifier.class).forDisplay(OrderInputEditor.class);
        MonetElementsService.register(TemplateNotifier.class).forDisplay(CheckListWizardStep.class);
        MonetElementsService.register(TemplateNotifier.class).forDisplay(CheckListWizardIndexEntry.class);
        MonetElementsService.register(TemplateNotifier.class).forDisplay(CheckListWizardStepPackageFile.class);
        MonetElementsService.register(ProgressDisplayNotifier.class).forDisplay(ProgressDisplay.class);
        MonetElementsService.register(AttachmentRendererNotifier.class).forDisplay(AttachmentRenderer.class);
        MonetElementsService.register(TemplateNotifier.class).forDisplay(AppTemplate.class);
        MonetElementsService.register(TemplateNotifier.class).forDisplay(Header.class);
        MonetElementsService.register(ItemNotifier.class).forDisplay(OrderTypeItem.class);
    }

    private static void initOrderTypesTemplate(UISpark spark, io.intino.alexandria.ui.services.push.PushService pushService) {
        ((UIRouter)spark.route("/ordertypestemplate/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/ordertypestemplate/:displayId")).post(manager -> new TemplateRequester(manager, MonetElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/ordertypestemplate/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("ordertypestemplate", (DisplayPushRequester)new TemplatePushRequester());
    }

    private static void initOrderTemplate(UISpark spark, io.intino.alexandria.ui.services.push.PushService pushService) {
        ((UIRouter)spark.route("/ordertemplate/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/ordertemplate/:displayId")).post(manager -> new TemplateRequester(manager, MonetElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/ordertemplate/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("ordertemplate", (DisplayPushRequester)new TemplatePushRequester());
        ((UIRouter)spark.route("/ordertemplateproxy/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/ordertemplateproxy/:displayId")).post(manager -> new OrderTemplateProxyRequester((UISparkManager)manager, MonetElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/ordertemplateproxy/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
    }

    private static void initOrderInputEditor(UISpark spark, io.intino.alexandria.ui.services.push.PushService pushService) {
        ((UIRouter)spark.route("/orderinputeditor/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/orderinputeditor/:displayId")).post(manager -> new TemplateRequester(manager, MonetElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/orderinputeditor/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("orderinputeditor", (DisplayPushRequester)new TemplatePushRequester());
    }

    private static void initCheckListWizardStep(UISpark spark, io.intino.alexandria.ui.services.push.PushService pushService) {
        ((UIRouter)spark.route("/checklistwizardstep/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/checklistwizardstep/:displayId")).post(manager -> new TemplateRequester(manager, MonetElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/checklistwizardstep/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("checklistwizardstep", (DisplayPushRequester)new TemplatePushRequester());
    }

    private static void initCheckListWizardIndexEntry(UISpark spark, io.intino.alexandria.ui.services.push.PushService pushService) {
        ((UIRouter)spark.route("/checklistwizardindexentry/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/checklistwizardindexentry/:displayId")).post(manager -> new TemplateRequester(manager, MonetElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/checklistwizardindexentry/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("checklistwizardindexentry", (DisplayPushRequester)new TemplatePushRequester());
    }

    private static void initCheckListWizardStepPackageFile(UISpark spark, io.intino.alexandria.ui.services.push.PushService pushService) {
        ((UIRouter)spark.route("/checklistwizardsteppackagefile/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/checklistwizardsteppackagefile/:displayId")).post(manager -> new TemplateRequester(manager, MonetElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/checklistwizardsteppackagefile/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("checklistwizardsteppackagefile", (DisplayPushRequester)new TemplatePushRequester());
    }

    private static void initProgressDisplay(UISpark spark, io.intino.alexandria.ui.services.push.PushService pushService) {
        ((UIRouter)spark.route("/progressdisplay/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/progressdisplay/:displayId")).post(manager -> new ProgressDisplayRequester((UISparkManager)manager, MonetElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/progressdisplay/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("progressdisplay", (DisplayPushRequester)new ProgressDisplayPushRequester());
    }

    private static void initAttachmentRenderer(UISpark spark, io.intino.alexandria.ui.services.push.PushService pushService) {
        ((UIRouter)spark.route("/attachmentrenderer/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/attachmentrenderer/:displayId")).post(manager -> new AttachmentRendererRequester((UISparkManager)manager, MonetElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/attachmentrenderer/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("attachmentrenderer", (DisplayPushRequester)new AttachmentRendererPushRequester());
    }

    private static void initAppTemplate(UISpark spark, io.intino.alexandria.ui.services.push.PushService pushService) {
        ((UIRouter)spark.route("/apptemplate/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/apptemplate/:displayId")).post(manager -> new TemplateRequester(manager, MonetElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/apptemplate/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("apptemplate", (DisplayPushRequester)new TemplatePushRequester());
    }

    private static void initHeader(UISpark spark, io.intino.alexandria.ui.services.push.PushService pushService) {
        ((UIRouter)spark.route("/header/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/header/:displayId")).post(manager -> new TemplateRequester(manager, MonetElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/header/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("header", (DisplayPushRequester)new TemplatePushRequester());
    }

    private static void initOrderTypeItem(UISpark spark, io.intino.alexandria.ui.services.push.PushService pushService) {
        ((UIRouter)spark.route("/ordertypeitem/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/ordertypeitem/:displayId")).post(manager -> new ItemRequester(manager, MonetElementsService.notifierProvider()).execute());
        ((UIRouter)spark.route("/ordertypeitem/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("ordertypeitem", (DisplayPushRequester)new ItemPushRequester());
    }
}

