/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.box.actions;

import io.intino.alexandria.exceptions.BadRequest;
import io.intino.alexandria.exceptions.Conflict;
import io.intino.monet.box.MonetBox;
import io.intino.monet.box.OrderApi;
import io.intino.monet.box.actions.MonetAction;
import io.intino.monet.box.commands.order.ResolveOrderCommand;
import io.intino.monet.box.util.FormHelper;
import io.intino.monet.engine.Order;
import io.intino.monet.engine.edition.Form;
import io.intino.monet.engine.edition.FormDefinition;
import io.intino.monet.engine.edition.FormStore;
import io.intino.monet.engine.edition.LocalFormStore;
import java.io.File;
import java.io.IOException;
import java.time.Instant;

public class PutFinishOrderAction
extends MonetAction {
    public MonetBox box;
    public String input;
    public String code;
    public String orderId;
    public String properties;

    public Boolean execute() throws Conflict, BadRequest {
        OrderApi orderApi = this.box.orderApi();
        Order order = orderApi.order(this.orderId);
        if (order == null) {
            throw new Conflict("Order not found");
        }
        order.input(this.input);
        order.properties(this.properties);
        ResolveOrderCommand command = new ResolveOrderCommand(this.box);
        command.author = "api";
        command.ts = Instant.now();
        command.order = order;
        command.testEnvironment = false;
        command.language = "en";
        command.form = this.form(order);
        command.execute();
        return true;
    }

    private Form form(Order order) {
        return new Form(this.formDefinition(order), this.store(order));
    }

    private FormDefinition formDefinition(Order order) {
        return FormHelper.formDefinition(this.box, order);
    }

    private FormStore store(Order order) {
        File directory = this.box.archetype().repository().workorders().getStoreDirectory(order.store());
        LocalFormStore result = new LocalFormStore(directory);
        try {
            result.load();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fillInputs(result, order);
        return result;
    }

    private void fillInputs(LocalFormStore result, Order order) {
        order.inputMap().forEach((arg_0, arg_1) -> ((LocalFormStore)result).put(arg_0, arg_1));
    }
}

