/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.box;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.scheduler.AlexandriaScheduler;
import io.intino.monet.box.MonetBox;
import io.intino.monet.box.scheduling.CommitDatabasesListener;
import java.io.File;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

public class Sentinels {
    private Sentinels() {
    }

    public static void init(AlexandriaScheduler scheduler, File home, MonetBox box) {
        try {
            JobDetail job = JobBuilder.newJob(CommitDatabasesListener.class).withIdentity("commitDatabases").build();
            job.getJobDataMap().put("box", (Object)box);
            scheduler.scheduleJob(job, Sentinels.newSet(TriggerBuilder.newTrigger().withIdentity("Sentinels#commitDatabases").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)"0/5 0/1 * 1/1 * ? *")).build()), true);
            scheduler.startSchedules();
        }
        catch (Exception e) {
            Logger.error((String)e.getMessage());
        }
    }

    private static Set<Trigger> newSet(Trigger ... triggers) {
        LinkedHashSet<Trigger> set = new LinkedHashSet<Trigger>();
        Collections.addAll(set, triggers);
        return set;
    }
}

