package io.intino.monet.box.util;

import io.intino.alexandria.logger.Logger;
import io.intino.monet.box.WorkReportGenerator;
import io.intino.monet.engine.Order;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;

import java.io.File;
import java.io.IOException;
import java.util.Map;

public class WorkReportHelper {

	public static Map<String, String> addCalculationsTo(Map<String, String> input, Order order, WorkReportGenerator.Archetype.OrderTypes templates) {
		try {
			File file = WorkReportHelper.calculationTemplate(templates, order);
			if (!file.exists()) return input;
			return new WorkReportCalculator(file, input).update();
		} catch (IOException | InvalidFormatException e) {
			Logger.error(e);
			return input;
		}
	}

	public static File template(WorkReportGenerator.Archetype.OrderTypes templates, String area, Order order, String language) {
		final String code = order.code();
		File file = null;
		for (int i = 0; i < 3; i++) {
			file = template(templates, area, code.substring(0, code.length() - i), language);
			if (file.exists()) return file;
		}
		if (!file.exists()) file = templates.defaultWorkReport(order.code());
		return file;
	}

	public static File calculationTemplate(WorkReportGenerator.Archetype.OrderTypes templates, Order order) {
		final String code = order.code();
		File file = null;
		for (int i = 0; i < 3; i++) {
			file = calculationTemplate(templates, code.substring(0, code.length() - i));
			if (file.exists()) return file;
		}
		if (!file.exists()) file = templates.workReportCalculation(order.code());
		return file;
	}

	private static File template(WorkReportGenerator.Archetype.OrderTypes templates, String area, String order, String language){
		if (area == null) area = "default";
		File file = templates.areaWorkReport(order, area);
		if (file.exists()) return file;
		file = templates.languageWorkReport(order, language);
		if (file.exists()) return file;
		return templates.defaultWorkReport(order);
	}

	private static File calculationTemplate(WorkReportGenerator.Archetype.OrderTypes templates, String order) {
		return templates.workReportCalculation(order);
	}

}
