package io.intino.monet.box.ui.displays.templates;

import io.intino.monet.box.MonetBox;

import java.util.function.Consumer;

public class OrderInputEditor extends AbstractOrderInputEditor<MonetBox> {
    private String input;
    private String _value;
    private Consumer<String> changeListener;

    public OrderInputEditor(MonetBox box) {
        super(box);
    }

    public void input(String input, String value) {
        this.input = input;
        this._value = value;
    }

    public void onChange(Consumer<String> listener) {
        this.changeListener = listener;
    }

    @Override
    public void init() {
        super.init();
        value.onChange(e -> changeListener.accept(e.value()));
    }

    @Override
    public void refresh() {
        super.refresh();
        label.value(input);
        value.value(_value);
    }

}