package io.intino.monet.box.ui.displays.templates;

import io.intino.alexandria.core.Box;
import io.intino.monet.box.MonetBox;
import io.intino.monet.box.util.Formatters;
import io.intino.monet.engine.edition.Edition;
import io.intino.monet.engine.edition.Form;
import io.intino.monet.engine.edition.editors.ImageEdition;
import io.intino.monet.engine.edition.editors.SectionEdition;
import io.intino.monet.engine.edition.editors.PackageEdition;
import io.intino.monet.engine.edition.editors.SignatureEdition;

import java.util.function.Consumer;

public class CheckListWizardIndexEntry extends AbstractCheckListWizardIndexEntry<MonetBox> {
    private Form form;
    private Edition edition;
    private Consumer<Edition> selectListener;

    public CheckListWizardIndexEntry(Box box) {
        super((MonetBox) box);
    }

    public CheckListWizardIndexEntry form(Form form) {
        this.form = form;
        return this;
    }

    public CheckListWizardIndexEntry edition(Edition edition) {
        this.edition = edition;
        return this;
    }

    public CheckListWizardIndexEntry onSelect(Consumer<Edition> listener) {
        this.selectListener = listener;
        return this;
    }

    @Override
    public void init() {
        super.init();
        label.onExecute(e -> selectListener.accept(edition));
    }

    @Override
    public void refresh() {
        super.refresh();
        label.title(form.field(edition.name()).title());
        content.value(value());
    }

    private String value() {
        Object value = edition.value();
        if (edition instanceof SectionEdition) return translate(edition.isSkipped() || edition.isEmpty() ? "Not filled" : "Filled");
        if (edition instanceof PackageEdition) return Formatters.countMessage(edition.as(PackageEdition.class).get().files().size(), "file", "files", language());
        if (edition instanceof ImageEdition) return imageValue();
        if (edition instanceof SignatureEdition) return signatureValue();
        if (value instanceof Object[]) return ((Object[])value).length > 0 ? (String) ((Object[])value)[0] : null;
        return format((value instanceof String) ? (String) value : String.valueOf(value));
    }

    private String format(String value) {
        return value.replace("<br/>", "\n");
    }

    private String imageValue() {
        ImageEdition.Image image = edition.as(ImageEdition.class).get();
        String label = image != null && image.label != null && !image.label.isEmpty() ? image.label : null;
        return translate(image != null ? "Image defined" : "Image not defined") + (label != null ? " (" + label + ")" : "");
    }

    private String signatureValue() {
        SignatureEdition.Signature signature = edition.as(SignatureEdition.class).get();
        return translate(signature != null ? "Signature defined" : "Signature not defined");
    }

}