package io.intino.monet.box.ui;
import io.intino.monet.box.ui.displays.*;
import io.intino.monet.box.ui.displays.notifiers.*;
import io.intino.monet.box.ui.displays.requesters.*;
import io.intino.monet.box.ui.resources.*;
import io.intino.monet.box.MonetBox;
import io.intino.monet.box.MonetConfiguration;

import io.intino.alexandria.ui.UISpark;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifier;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.displays.DisplayRouteDispatcher;
import io.intino.alexandria.ui.resources.AssetResourceLoader;
import io.intino.alexandria.ui.services.push.PushService;
import io.intino.alexandria.ui.spark.resources.AfterDisplayRequest;
import io.intino.alexandria.ui.spark.resources.AssetResource;
import io.intino.alexandria.ui.spark.resources.AuthenticateCallbackResource;
import io.intino.alexandria.ui.spark.resources.BeforeDisplayRequest;

import java.net.MalformedURLException;
import java.net.URL;

public class MonetElementsService extends io.intino.alexandria.ui.UI {

	public static void init(UISpark spark, MonetBox box, PushService pushService, DisplayRouteDispatcher routeDispatcher) {
		MonetConfiguration configuration = (MonetConfiguration) box.configuration();
		box.routeManager(routeManager(spark, routeDispatcher));
		spark.route("/push").push(pushService);
		spark.route("/authenticate-callback").get(manager -> new AuthenticateCallbackResource(manager, notifierProvider()).execute());
		spark.route("/authenticate-callback/").get(manager -> new AuthenticateCallbackResource(manager, notifierProvider()).execute());
		spark.route("/asset/:name").get(manager -> new AssetResource(name -> new AssetResourceLoader(box).load(name), manager, notifierProvider()).execute());
		spark.route("/alexandria/user").get(manager -> new HomeResource(box, manager, notifierProvider()).execute());
		spark.route("/").get(manager -> new HomeResource(box, manager, notifierProvider()).execute());
		spark.route("/order/:id").get(manager -> new OrderPageResource(box, manager, notifierProvider()).execute());
		spark.route("/ordertemplateproxy/:displayId/personify").post(manager -> new OrderTemplateProxyResource(box, manager, notifierProvider()).execute());
		initDisplays(spark, pushService);
	}

	public static void initDisplays(UISpark spark, PushService pushService) {
		initOrderTypesTemplate(spark, pushService);
		initOrderTemplate(spark, pushService);
		initOrderInputEditor(spark, pushService);
		initCheckListWizardStep(spark, pushService);
		initCheckListWizardIndexEntry(spark, pushService);
		initCheckListWizardStepPackageFile(spark, pushService);
		initProgressDisplay(spark, pushService);
		initAttachmentRenderer(spark, pushService);
		initAppTemplate(spark, pushService);
		initHeader(spark, pushService);
		initOrderTypeItem(spark, pushService);
		registerNotifiers();
	}

	private static void registerNotifiers() {
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.monet.box.ui.displays.templates.OrderTypesTemplate.class);
		register(OrderTemplateNotifier.class).forDisplay(io.intino.monet.box.ui.displays.templates.OrderTemplate.class);
		register(OrderTemplateProxyNotifier.class).forDisplay(io.intino.monet.box.ui.displays.templates.OrderTemplateProxy.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.monet.box.ui.displays.templates.OrderInputEditor.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.monet.box.ui.displays.templates.CheckListWizardStep.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.monet.box.ui.displays.templates.CheckListWizardIndexEntry.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.monet.box.ui.displays.templates.CheckListWizardStepPackageFile.class);
		register(ProgressDisplayNotifier.class).forDisplay(io.intino.monet.box.ui.displays.ProgressDisplay.class);
		register(AttachmentRendererNotifier.class).forDisplay(io.intino.monet.box.ui.displays.AttachmentRenderer.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.monet.box.ui.displays.templates.AppTemplate.class);
		register(io.intino.alexandria.ui.displays.notifiers.TemplateNotifier.class).forDisplay(io.intino.monet.box.ui.displays.templates.Header.class);
		register(io.intino.alexandria.ui.displays.notifiers.ItemNotifier.class).forDisplay(io.intino.monet.box.ui.displays.items.OrderTypeItem.class);
	}

    private static void initOrderTypesTemplate(UISpark spark, PushService pushService) {
        spark.route("/ordertypestemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
        spark.route("/ordertypestemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
        spark.route("/ordertypestemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("ordertypestemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

    }
    private static void initOrderTemplate(UISpark spark, PushService pushService) {
        spark.route("/ordertemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
        spark.route("/ordertemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
        spark.route("/ordertemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("ordertemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());
        spark.route("/ordertemplateproxy/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
        spark.route("/ordertemplateproxy/:displayId").post(manager -> new OrderTemplateProxyRequester(manager, notifierProvider()).execute());
        spark.route("/ordertemplateproxy/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
    }
    private static void initOrderInputEditor(UISpark spark, PushService pushService) {
        spark.route("/orderinputeditor/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
        spark.route("/orderinputeditor/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
        spark.route("/orderinputeditor/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("orderinputeditor", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

    }
    private static void initCheckListWizardStep(UISpark spark, PushService pushService) {
        spark.route("/checklistwizardstep/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
        spark.route("/checklistwizardstep/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
        spark.route("/checklistwizardstep/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("checklistwizardstep", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

    }
    private static void initCheckListWizardIndexEntry(UISpark spark, PushService pushService) {
        spark.route("/checklistwizardindexentry/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
        spark.route("/checklistwizardindexentry/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
        spark.route("/checklistwizardindexentry/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("checklistwizardindexentry", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

    }
    private static void initCheckListWizardStepPackageFile(UISpark spark, PushService pushService) {
        spark.route("/checklistwizardsteppackagefile/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
        spark.route("/checklistwizardsteppackagefile/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
        spark.route("/checklistwizardsteppackagefile/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("checklistwizardsteppackagefile", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

    }
    private static void initProgressDisplay(UISpark spark, PushService pushService) {
        spark.route("/progressdisplay/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
        spark.route("/progressdisplay/:displayId").post(manager -> new ProgressDisplayRequester(manager, notifierProvider()).execute());
        spark.route("/progressdisplay/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("progressdisplay", new ProgressDisplayPushRequester());

    }
    private static void initAttachmentRenderer(UISpark spark, PushService pushService) {
        spark.route("/attachmentrenderer/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
        spark.route("/attachmentrenderer/:displayId").post(manager -> new AttachmentRendererRequester(manager, notifierProvider()).execute());
        spark.route("/attachmentrenderer/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("attachmentrenderer", new AttachmentRendererPushRequester());

    }
    private static void initAppTemplate(UISpark spark, PushService pushService) {
        spark.route("/apptemplate/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
        spark.route("/apptemplate/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
        spark.route("/apptemplate/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("apptemplate", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

    }
    private static void initHeader(UISpark spark, PushService pushService) {
        spark.route("/header/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
        spark.route("/header/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.TemplateRequester(manager, notifierProvider()).execute());
        spark.route("/header/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("header", new io.intino.alexandria.ui.displays.requesters.TemplatePushRequester());

    }
    private static void initOrderTypeItem(UISpark spark, PushService pushService) {
        spark.route("/ordertypeitem/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
        spark.route("/ordertypeitem/:displayId").post(manager -> new io.intino.alexandria.ui.displays.requesters.ItemRequester(manager, notifierProvider()).execute());
        spark.route("/ordertypeitem/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
        pushService.register("ordertypeitem", new io.intino.alexandria.ui.displays.requesters.ItemPushRequester());

    }
}