package io.intino.monet.box.rest.resources;

import java.util.List;
import java.util.ArrayList;
import io.intino.alexandria.exceptions.*;
import io.intino.monet.box.*;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.rest.*;
import io.intino.alexandria.http.spark.SparkManager;
import io.intino.alexandria.http.spark.SparkPushService;

import io.intino.monet.box.schemas.*;

public class PutFinishOrderResource implements Resource {

	private MonetBox box;
	private SparkManager<SparkPushService> manager;

	public PutFinishOrderResource(MonetBox box, SparkManager manager) {
		this.box = box;
		this.manager = manager;
	}

	public void execute() throws AlexandriaException {
		write(fill(new io.intino.monet.box.actions.PutFinishOrderAction()).execute());
	}

	private io.intino.monet.box.actions.PutFinishOrderAction fill(io.intino.monet.box.actions.PutFinishOrderAction action) throws AlexandriaException {
		action.box = this.box;
		action.context = context();
		try {
			action.orderId = io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromPath("orderId"), String.class);
			action.code = io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromQueryOrElseThrow("code", () -> new BadRequest("Parameters missed")), String.class);
			action.input = io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromQueryOrElseThrow("input", () -> new BadRequest("Parameters missed")), String.class);
			action.properties = io.intino.alexandria.rest.RequestAdapter.adapt(manager.fromQuery("properties"), String.class);
		} catch (Throwable e) {
			action.onMalformedRequest(e);
		}
		return action;
	}

	private void write(Boolean object) {
		manager.write(io.intino.alexandria.rest.ResponseAdapter.adapt(object));
	}

	private io.intino.alexandria.http.spark.SparkContext context() {
		io.intino.alexandria.http.spark.SparkContext context = new io.intino.alexandria.http.spark.SparkContext(manager);

		context.put("ip", manager.ip());
		return context;
	}
}