package io.intino.monet.box.actions;

import io.intino.alexandria.exceptions.Conflict;
import io.intino.monet.box.MonetBox;
import io.intino.monet.box.OrderApi;

public class DeleteOrderAction extends MonetAction {
	public MonetBox box;
	public String orderId;

	public Boolean execute() throws Conflict {
		OrderApi orderApi = box.orderApi();
		io.intino.monet.engine.Order order = orderApi.order(orderId);
		if (order == null) throw new Conflict("Order not found");
		orderApi.delete(order);
		return true;
	}

}