/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.box.workreports;

import io.intino.alexandria.Resource;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.office.components.Image;
import io.intino.alexandria.office.components.ImageView;
import io.intino.monet.box.ImageViewFactory;
import io.intino.monet.box.WorkReportGenerator;
import io.intino.monet.box.util.Resources;
import io.intino.monet.box.util.WorkReportHelper;
import io.intino.monet.box.workreports.WorkReportInfoProvider;
import io.intino.monet.box.workreports.WorkReportTemplate;
import io.intino.monet.engine.CheckListProvider;
import io.intino.monet.engine.Order;
import io.intino.monet.engine.OrderTypes;
import io.intino.monet.engine.WorkReport;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class WorkReportBuilder {
    private static final String MAIN_TEMPLATE_NAME = "main";
    private final WorkReportGenerator.Archetype archetype;
    private WorkReport workReport;
    private WorkReportInfoProvider infoProvider;
    private OrderTypes.Checklist checklist;
    private final Map<String, WorkReportTemplate> templates = new LinkedHashMap<String, WorkReportTemplate>();
    private ImageViewFactory imageViewFactory = new ImageViewFactory.Default();
    private boolean computeCalculations = true;

    public WorkReportBuilder(WorkReportGenerator.Archetype archetype) {
        this.archetype = archetype;
    }

    public Map<String, WorkReportTemplate> build() throws WorkReportException {
        this.validate();
        this.templates.clear();
        this.buildDocuments();
        return this.templates;
    }

    private void buildDocuments() throws WorkReportException {
        this.createMainTemplate();
        this.createSecondaryTemplates();
        this.fillWorkReportTemplates();
    }

    private void fillWorkReportTemplates() {
        this.setInputs(this.mainTemplate());
        this.setBasicInfo(this.mainTemplate());
        Map workReportChecks = this.computeCalculations ? this.withCalculations() : this.workReport.attributes();
        this.setChecksAndCalculations(workReportChecks);
        this.setImages();
        this.handleNotDefinedImages();
        this.setDefaultValuesForNotProcessedChecks(workReportChecks);
    }

    protected void setChecksAndCalculations(Map<String, String> workReportChecks) {
        for (Map.Entry<String, String> checkEntry : workReportChecks.entrySet()) {
            WorkReportTemplate template;
            String name = checkEntry.getKey();
            OrderTypes.Checklist.Field check = this.getCheck(name);
            WorkReportTemplate workReportTemplate = template = check != null ? this.templateOf(check) : this.templateOf(name);
            if (template == null) {
                Logger.warn((String)("Template of " + name + " not found..."));
                return;
            }
            this.setTemplateField(checkEntry, name, template);
        }
    }

    protected void setTemplateField(Map.Entry<String, String> checkEntry, String name, WorkReportTemplate template) {
        String value = checkEntry.getValue().replace("<br/>", "\n");
        template.set(this.checkName(name), value);
    }

    private void setDefaultValuesForNotProcessedChecks(Map<String, String> workReportChecks) {
        Set notProcessedChecks = this.checklist.fields().stream().map(f -> f.name).collect(Collectors.toSet());
        notProcessedChecks.removeAll(workReportChecks.keySet());
        for (WorkReportTemplate template : this.templates.values()) {
            for (String check : notProcessedChecks) {
                if (!WorkReportBuilder.isCheckOfTemplate(template, check)) continue;
                if (check.contains("+")) {
                    check = check.substring(0, check.indexOf(43));
                }
                if (template.contains(check)) continue;
                template.set(check, "");
            }
        }
    }

    private OrderTypes.Checklist.Field getCheck(String name) {
        return this.checklist.fields().stream().filter(f -> f.name.equals(name)).findFirst().orElse(null);
    }

    protected void setBasicInfo(WorkReportTemplate mainTemplate) {
        this.infoProvider.info().forEach(mainTemplate::set);
    }

    private String valueOrEmpty(String value) {
        return value != null ? value : "";
    }

    protected void setInputs(WorkReportTemplate mainTemplate) {
        Order order = this.workReport.order();
        if (order.inputMap() != null) {
            order.inputMap().forEach(mainTemplate::set);
        }
    }

    private Map<String, String> withCalculations() {
        return WorkReportHelper.addCalculationsTo(this.workReport.attributes(), this.workReport.order(), this.archetype.orderTypes());
    }

    protected void setImages() {
        for (Resource image : this.workReport.images()) {
            this.setImage(image);
        }
    }

    private void handleNotDefinedImages() {
        for (WorkReportTemplate template : this.templates.values()) {
            this.imagesOfTemplate(template).forEach(check -> this.tryPut((OrderTypes.Checklist.Field)check, template));
        }
    }

    private void tryPut(OrderTypes.Checklist.Field check, WorkReportTemplate template) {
        String name;
        String string = name = check.name.contains("+") ? check.name.substring(0, check.name.indexOf(43)) : check.name;
        if (template.containsImage(name)) {
            return;
        }
        byte[] imageData = this.getImageForTemplateState(template);
        if (imageData.length == 0) {
            return;
        }
        try {
            this.setImage(name, template, imageData);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private Stream<OrderTypes.Checklist.Field> imagesOfTemplate(WorkReportTemplate template) {
        return this.checklist.fields().stream().filter(this::isImageCheck).filter(c -> WorkReportBuilder.isCheckOfTemplate(template, c.name));
    }

    private static boolean isCheckOfTemplate(WorkReportTemplate template, String checkName) {
        if (checkName.contains("+")) {
            return checkName.endsWith("+" + template.name());
        }
        return template.isMainTemplate();
    }

    private boolean isImageCheck(OrderTypes.Checklist.Field field) {
        return field.type == OrderTypes.Checklist.Type.Image || field.type == OrderTypes.Checklist.Type.Note || field.type == OrderTypes.Checklist.Type.Signature;
    }

    protected void setImage(Resource image) {
        try {
            WorkReportTemplate template = this.templateOf(this.getCheck(image.name()));
            if (template == null) {
                Logger.warn((String)("Template of " + image.name() + " not found..."));
                return;
            }
            byte[] imageData = image.bytes();
            if (imageData.length == 0) {
                imageData = this.getImageForTemplateState(template);
            }
            if (imageData.length == 0) {
                return;
            }
            this.setImage(image.name(), template, imageData);
        }
        catch (Throwable e) {
            Logger.error((String)("Failed to create image " + image.name() + ": " + e.getMessage()), (Throwable)e);
        }
    }

    private void setImage(String name, WorkReportTemplate template, byte[] imageData) throws IOException {
        ImageView imageView = this.imageViewFactory.create(new Image(imageData));
        template.set(this.checkName(name), imageView);
    }

    private byte[] getImageForTemplateState(WorkReportTemplate template) {
        return !template.empty() || template.isMainTemplate() ? this.blankImage() : new byte[]{};
    }

    private byte[] blankImage() {
        byte[] byArray;
        block8: {
            InputStream inputStream = Resources.emptyImage();
            try {
                byArray = inputStream.readAllBytes();
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Logger.error((String)("Could not read empty image: " + e.getMessage()), (Throwable)e);
                    return new byte[0];
                }
            }
            inputStream.close();
        }
        return byArray;
    }

    private void createMainTemplate() {
        WorkReportTemplate template = new WorkReportTemplate(MAIN_TEMPLATE_NAME, WorkReportHelper.template(this.archetype.orderTypes(), this.workReport.area(), this.workReport.order(), this.workReport.language()));
        template.setAsMainTemplate();
        this.templates.put(MAIN_TEMPLATE_NAME, template);
    }

    private void createSecondaryTemplates() throws WorkReportException {
        Order order = this.workReport.order();
        OrderTypes.Record orderType = OrderTypes.of((String)order.code());
        if (orderType == null) {
            throw new WorkReportException("OrderType not found for order " + order.code());
        }
        for (String annex : orderType.annexes()) {
            String[] entry = annex.split(":");
            if (entry.length != 2) continue;
            String name = entry[0].trim();
            this.templates.put(name, this.templateOfFilename(name, entry[1].trim()));
        }
    }

    private WorkReportTemplate templateOf(OrderTypes.Checklist.Field check) {
        return this.templateOf(check.name);
    }

    private WorkReportTemplate templateOf(String name) {
        if (!name.contains("+")) {
            return this.mainTemplate();
        }
        return this.templates.get(name.substring(name.indexOf(43) + 1));
    }

    private WorkReportTemplate templateOfFilename(String name, String filename) {
        return new WorkReportTemplate(name, new File(this.mainTemplate().file().getAbsolutePath().replace(".docx", "$" + filename + ".docx")));
    }

    protected WorkReportTemplate mainTemplate() {
        return this.templates.get(MAIN_TEMPLATE_NAME);
    }

    protected String checkName(String name) {
        return !name.contains("+") ? name : name.substring(0, name.indexOf(43));
    }

    protected void validate() throws WorkReportException {
        if (this.workReport == null) {
            throw new WorkReportException("WorkReport is null");
        }
        if (this.workReport.order() == null) {
            throw new WorkReportException("WorkReport orderId is null");
        }
        if (this.workReport.language() == null) {
            throw new WorkReportException("Language is not specified");
        }
        this.checklist = new CheckListProvider().findCheckList(this.workReport.order().code());
        if (this.checklist == null) {
            throw new WorkReportException("No checklist found for order " + this.workReport.order().code());
        }
    }

    public <T extends WorkReport> T workReport() {
        return (T)this.workReport;
    }

    public WorkReportBuilder workReport(WorkReport workReport) {
        this.workReport = workReport;
        return this;
    }

    public WorkReportBuilder infoProvider(WorkReportInfoProvider infoProvider) {
        this.infoProvider = infoProvider;
        return this;
    }

    public WorkReportBuilder imageViewFactory(ImageViewFactory imageViewFactory) {
        this.imageViewFactory = imageViewFactory == null ? new ImageViewFactory.Default() : imageViewFactory;
        return this;
    }

    public WorkReportBuilder computeCalculations(boolean computeCalculations) {
        this.computeCalculations = computeCalculations;
        return this;
    }

    public static class WorkReportException
    extends Exception {
        public WorkReportException(String message) {
            super(message);
        }
    }
}

