/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.box.util;

import io.intino.alexandria.logger.Logger;
import io.intino.monet.box.WorkReportGenerator;
import io.intino.monet.box.util.WorkReportCalculator;
import io.intino.monet.engine.Order;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;

public class WorkReportHelper {
    public static Map<String, String> addCalculationsTo(Map<String, String> input, Order order, WorkReportGenerator.Archetype.OrderTypes templates) {
        try {
            File file = WorkReportHelper.calculationTemplate(templates, order);
            if (!file.exists()) {
                return input;
            }
            return new WorkReportCalculator(file, input).update();
        }
        catch (IOException | InvalidFormatException e) {
            Logger.error((Throwable)e);
            return input;
        }
    }

    public static File template(WorkReportGenerator.Archetype.OrderTypes templates, String area, Order order, String language) {
        String code = order.code();
        File file = null;
        for (int i = 0; i < 3; ++i) {
            file = WorkReportHelper.template(templates, area, code.substring(0, code.length() - i), language);
            if (!file.exists()) continue;
            return file;
        }
        if (!file.exists()) {
            file = templates.defaultWorkReport(order.code());
        }
        return file;
    }

    public static File calculationTemplate(WorkReportGenerator.Archetype.OrderTypes templates, Order order) {
        String code = order.code();
        File file = null;
        for (int i = 0; i < 3; ++i) {
            file = WorkReportHelper.calculationTemplate(templates, code.substring(0, code.length() - i));
            if (!file.exists()) continue;
            return file;
        }
        if (!file.exists()) {
            file = templates.workReportCalculation(order.code());
        }
        return file;
    }

    private static File template(WorkReportGenerator.Archetype.OrderTypes templates, String area, String order, String language) {
        File file;
        if (area == null) {
            area = "default";
        }
        if ((file = templates.areaWorkReport(order, area)).exists()) {
            return file;
        }
        file = templates.languageWorkReport(order, language);
        if (file.exists()) {
            return file;
        }
        return templates.defaultWorkReport(order);
    }

    private static File calculationTemplate(WorkReportGenerator.Archetype.OrderTypes templates, String order) {
        return templates.workReportCalculation(order);
    }
}

