/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.box.util;

import io.intino.alexandria.Resource;
import io.intino.alexandria.logger.Logger;
import io.intino.monet.box.ui.displays.templates.CheckListWizardStep;
import io.intino.monet.box.util.FormHelper;
import io.intino.monet.engine.Order;
import io.intino.monet.engine.OrderTypes;
import io.intino.monet.engine.edition.Form;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OrderHelper {
    public static final String SEP = "_";

    public static Map<String, String> valuesOf(Order order, Form form) {
        HashMap<String, String> result = new HashMap<String, String>();
        FormHelper.values(form).forEach((key, values) -> result.put((String)key, FormHelper.valueOf(values)));
        OrderHelper.addInputs(order, result);
        return result;
    }

    public static Object defaultValue(OrderTypes.Checklist.Field check) {
        OrderTypes.Checklist.Type type = check.type;
        if (type == OrderTypes.Checklist.Type.Image) {
            Resource empty = new Resource(check.name.replace(" ", "") + ".png", CheckListWizardStep.class.getResourceAsStream("/empty.png"));
            return List.of(empty, "");
        }
        if (type == OrderTypes.Checklist.Type.Note) {
            Resource empty = new Resource(check.name.replace(" ", "") + ".png", CheckListWizardStep.class.getResourceAsStream("/empty.png"));
            return List.of("", empty);
        }
        if (type == OrderTypes.Checklist.Type.Package) {
            return Collections.emptyList();
        }
        if (type == OrderTypes.Checklist.Type.MultiOption) {
            return Collections.emptyList();
        }
        return null;
    }

    private static String placeOf(String place) {
        return place.replace(".", "-");
    }

    public static String replaceVariables(String content, Map<String, String> variables) {
        if (content == null) {
            return null;
        }
        content = content.replace("\\n", "<br/>");
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            content = content.replaceAll("::" + key + "::", value);
        }
        return content;
    }

    public static String replaceInputs(Order order, String content) {
        Map<String, String> variables = order.inputMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> String.valueOf(e.getValue())));
        return OrderHelper.replaceVariables(content, variables);
    }

    public static Resource resourceOf(File file) {
        try {
            return new Resource(file.getName(), Files.readAllBytes(file.toPath()));
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    private static void addInputs(Order order, Map<String, String> result) {
        order.inputMap().forEach((key, value) -> {
            if (result.containsKey(key)) {
                return;
            }
            result.put((String)key, (String)value);
        });
    }
}

