/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.box.ui.displays;

import io.intino.alexandria.logger.Logger;
import io.intino.monet.box.MonetBox;
import io.intino.monet.box.ui.displays.AbstractAttachmentRenderer;
import io.intino.monet.box.ui.displays.notifiers.AttachmentRendererNotifier;
import io.intino.monet.box.util.OrderHelper;
import io.intino.monet.engine.Order;
import io.intino.monet.engine.edition.Field;
import io.intino.monet.engine.edition.Form;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Map;

public class AttachmentRenderer
extends AbstractAttachmentRenderer<MonetBox> {
    private Order order;
    private Form form;
    private Field field;
    private File attachment;

    public AttachmentRenderer(MonetBox box) {
        super(box);
    }

    public AttachmentRenderer order(Order order) {
        this.order = order;
        return this;
    }

    public AttachmentRenderer form(Form form) {
        this.form = form;
        return this;
    }

    public AttachmentRenderer field(Field field) {
        this.field = field;
        return this;
    }

    public AttachmentRenderer attachment(File attachment) {
        this.attachment = attachment;
        return this;
    }

    public void refresh() {
        super.refresh();
        ((AttachmentRendererNotifier)this.notifier).refresh(this.content());
    }

    private String content() {
        try {
            if (this.attachment == null || !this.attachment.exists()) {
                return "";
            }
            Map<String, String> values = OrderHelper.valuesOf(this.order, this.form);
            values.put("base-url", this.baseUrl());
            return OrderHelper.replaceVariables(Files.readString(this.attachment.toPath()), values);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return "";
        }
    }

    private String baseUrl() {
        String url = this.session().browser().baseUrl();
        url = (url = url.replace("://", "#BAR#")).contains("/") ? url.split("/")[0] : url;
        return url.replace("#BAR#", "://");
    }
}

