import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiTextCode from "alexandria-ui-elements/src/displays/components/TextCode";
import UiItem from "alexandria-ui-elements/src/displays/components/Item";
import OrderTypeItemNotifier from "alexandria-ui-elements/gen/displays/notifiers/ItemNotifier";
import OrderTypeItemRequester from "alexandria-ui-elements/gen/displays/requesters/ItemRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class OrderTypeItem extends UiItem {

	constructor(props) {
		super(props);
		this.notifier = new OrderTypeItemNotifier(this);
		this.requester = new OrderTypeItemRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<div style={{width:"100%",height:"100%",...this.props.style,...this.style(),...display}} className={className}>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a344419492" format="verySmallSize greyColor" mode="uppercase">
				</UiText>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2094962461" format="h5" mode="normal">
				</UiText>
				<UiTextCode context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_340515158" format="body2 cleanHtmlStyle" mode="normal" language="Html" value="">
				</UiTextCode>
			</div>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(OrderTypeItem));
DisplayFactory.register("OrderTypeItem", withStyles(styles, { withTheme: true })(withSnackbar(OrderTypeItem)));