/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.box.workreports;

import io.intino.alexandria.Resource;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.office.Image;
import io.intino.alexandria.office.ImageView;
import io.intino.monet.box.ImageViewFactory;
import io.intino.monet.box.MonetBox;
import io.intino.monet.box.util.Formatters;
import io.intino.monet.box.util.WorkReportHelper;
import io.intino.monet.box.workreports.WorkReportTemplate;
import io.intino.monet.engine.CheckListProvider;
import io.intino.monet.engine.Order;
import io.intino.monet.engine.OrderTypes;
import io.intino.monet.engine.WorkReport;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;

public class WorkReportBuilder {
    private static final String MAIN_TEMPLATE_NAME = "main";
    private final MonetBox box;
    private WorkReport workReport;
    private OrderTypes.Checklist checklist;
    private final Map<String, WorkReportTemplate> templates = new LinkedHashMap<String, WorkReportTemplate>();
    private ImageViewFactory imageViewFactory = new ImageViewFactory.Default();

    public WorkReportBuilder(MonetBox box) {
        this.box = box;
    }

    public Map<String, WorkReportTemplate> build() throws WorkReportException {
        this.validate();
        this.templates.clear();
        this.buildDocuments();
        return this.templates;
    }

    private void buildDocuments() throws WorkReportException {
        this.createMainTemplate();
        this.createSecondaryTemplates();
        this.fillWorkReportTemplates();
    }

    private void fillWorkReportTemplates() {
        this.setInputs(this.mainTemplate());
        this.setBasicInfo(this.mainTemplate());
        this.setChecksAndCalculations();
        this.setImages();
    }

    protected void setChecksAndCalculations() {
        Map<String, String> workReportChecks = this.withCalculations();
        for (Map.Entry<String, String> checkEntry : workReportChecks.entrySet()) {
            WorkReportTemplate template;
            String name = checkEntry.getKey();
            OrderTypes.Checklist.Field check = this.getCheck(name);
            WorkReportTemplate workReportTemplate = template = check != null ? this.templateOf(check) : this.templateOf(name);
            if (template == null) {
                Logger.warn((String)("Template of " + name + " not found..."));
                return;
            }
            template.set(this.checkName(name), checkEntry.getValue());
        }
    }

    private OrderTypes.Checklist.Field getCheck(String name) {
        return this.checklist.fields().stream().filter(f -> f.name.equals(name)).findFirst().orElse(null);
    }

    protected void setBasicInfo(WorkReportTemplate mainTemplate) {
        mainTemplate.set("date", Formatters.textDate(this.workReport.finished(), this.workReport.language()));
        mainTemplate.set("comments", this.workReport.comments() == null ? "" : this.workReport.comments());
    }

    private String valueOrEmpty(String value) {
        return value != null ? value : "";
    }

    protected void setInputs(WorkReportTemplate mainTemplate) {
        Order order = this.workReport.order();
        if (order.inputMap() != null) {
            order.inputMap().forEach(mainTemplate::set);
        }
    }

    private Map<String, String> withCalculations() {
        return WorkReportHelper.addCalculationsTo(this.workReport.attributes(), this.workReport.order(), this.box.archetype().definitions().orderTypes());
    }

    protected void setImages() {
        for (Resource image : this.workReport.images()) {
            this.setImage(image);
        }
    }

    protected void setImage(Resource image) {
        try {
            ImageView imageView = this.imageViewFactory.create(new Image(image.bytes()));
            WorkReportTemplate template = this.templateOf(this.getCheck(image.name()));
            if (template == null) {
                Logger.warn((String)("Template of " + image.name() + " not found..."));
                return;
            }
            template.set(this.checkName(image.name()), imageView);
        }
        catch (Throwable e) {
            Logger.error((String)("Failed to create image " + image.name() + ": " + e.getMessage()), (Throwable)e);
        }
    }

    private void createMainTemplate() {
        WorkReportTemplate template = new WorkReportTemplate(WorkReportHelper.template(this.box.archetype().definitions().orderTypes(), this.workReport.area(), this.workReport.order(), this.workReport.language()));
        this.templates.put(MAIN_TEMPLATE_NAME, template);
    }

    private void createSecondaryTemplates() throws WorkReportException {
        Order order = this.workReport.order();
        OrderTypes.Record orderType = OrderTypes.of((String)order.code());
        if (orderType == null) {
            throw new WorkReportException("OrderType not found for order " + order.code());
        }
        for (String annex : orderType.annexes()) {
            String[] entry = annex.split(":");
            if (entry.length != 2) continue;
            this.templates.put(entry[0].trim(), this.templateOfFilename(entry[1].trim()));
        }
    }

    private WorkReportTemplate templateOf(OrderTypes.Checklist.Field check) {
        return this.templateOf(check.name);
    }

    private WorkReportTemplate templateOf(String name) {
        if (!name.contains("+")) {
            return this.mainTemplate();
        }
        return this.templates.get(name.substring(name.indexOf(43) + 1));
    }

    private WorkReportTemplate templateOfFilename(String filename) {
        return new WorkReportTemplate(new File(this.mainTemplate().file().getAbsolutePath().replace(".docx", "$" + filename + ".docx")));
    }

    private WorkReportTemplate mainTemplate() {
        return this.templates.get(MAIN_TEMPLATE_NAME);
    }

    private String checkName(String name) {
        return !name.contains("+") ? name : name.substring(0, name.indexOf(43));
    }

    protected void validate() throws WorkReportException {
        if (this.workReport == null) {
            throw new WorkReportException("WorkReport is null");
        }
        if (this.workReport.order() == null) {
            throw new WorkReportException("WorkReport orderId is null");
        }
        if (this.workReport.language() == null) {
            throw new WorkReportException("Language is not specified");
        }
        this.checklist = new CheckListProvider().findCheckList(this.workReport.order().code());
        if (this.checklist == null) {
            throw new WorkReportException("No checklist found for order " + this.workReport.order().code());
        }
    }

    public <T extends WorkReport> T workReport() {
        return (T)this.workReport;
    }

    public WorkReportBuilder workReport(WorkReport workReport) {
        this.workReport = workReport;
        return this;
    }

    public WorkReportBuilder imageViewFactory(ImageViewFactory imageViewFactory) {
        this.imageViewFactory = imageViewFactory == null ? new ImageViewFactory.Default() : imageViewFactory;
        return this;
    }

    public static class WorkReportException
    extends Exception {
        public WorkReportException(String message) {
            super(message);
        }
    }
}

