/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.box.ui.displays.templates;

import io.intino.alexandria.core.Box;
import io.intino.monet.box.MonetBox;
import io.intino.monet.box.ui.displays.templates.AbstractCheckListWizardIndexEntry;
import io.intino.monet.box.util.Formatters;
import io.intino.monet.engine.edition.Edition;
import io.intino.monet.engine.edition.Form;
import io.intino.monet.engine.edition.editors.ImageEdition;
import io.intino.monet.engine.edition.editors.PackageEdition;
import io.intino.monet.engine.edition.editors.SectionEdition;
import io.intino.monet.engine.edition.editors.SignatureEdition;
import java.util.function.Consumer;

public class CheckListWizardIndexEntry
extends AbstractCheckListWizardIndexEntry<MonetBox> {
    private Form form;
    private Edition edition;
    private Consumer<Edition> selectListener;

    public CheckListWizardIndexEntry(Box box) {
        super((MonetBox)box);
    }

    public CheckListWizardIndexEntry form(Form form) {
        this.form = form;
        return this;
    }

    public CheckListWizardIndexEntry edition(Edition edition) {
        this.edition = edition;
        return this;
    }

    public CheckListWizardIndexEntry onSelect(Consumer<Edition> listener) {
        this.selectListener = listener;
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.label.onExecute(e -> this.selectListener.accept(this.edition));
    }

    public void refresh() {
        super.refresh();
        this.label.title(this.form.field(this.edition.name()).title());
        this.content.value(this.value());
    }

    private String value() {
        Object value = this.edition.value();
        if (this.edition instanceof SectionEdition) {
            return this.translate(this.edition.isSkipped() || this.edition.isEmpty() ? "Not filled" : "Filled");
        }
        if (this.edition instanceof PackageEdition) {
            return Formatters.countMessage(((PackageEdition)this.edition.as(PackageEdition.class)).get().files().size(), "file", "files", this.language());
        }
        if (this.edition instanceof ImageEdition) {
            return this.imageValue();
        }
        if (this.edition instanceof SignatureEdition) {
            return this.signatureValue();
        }
        if (value instanceof Object[]) {
            return ((Object[])value).length > 0 ? (String)((Object[])value)[0] : null;
        }
        return this.format(value instanceof String ? (String)value : String.valueOf(value));
    }

    private String format(String value) {
        return value.replace("<br/>", "\n");
    }

    private String imageValue() {
        ImageEdition.Image image = ((ImageEdition)this.edition.as(ImageEdition.class)).get();
        String label = image != null && image.label != null && !image.label.isEmpty() ? image.label : null;
        return this.translate(image != null ? "Image defined" : "Image not defined") + (String)(label != null ? " (" + label + ")" : "");
    }

    private String signatureValue() {
        SignatureEdition.Signature signature = ((SignatureEdition)this.edition.as(SignatureEdition.class)).get();
        return this.translate(signature != null ? "Signature defined" : "Signature not defined");
    }
}

