/*
 * Decompiled with CFR 0.152.
 */
package io.intino.monet.box;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.exceptions.BadRequest;
import io.intino.alexandria.exceptions.Conflict;
import io.intino.alexandria.exceptions.InternalServerError;
import io.intino.alexandria.restaccessor.OutBox;
import io.intino.alexandria.restaccessor.RequestBuilder;
import io.intino.alexandria.restaccessor.Response;
import io.intino.alexandria.restaccessor.adapters.ResponseAdapter;
import io.intino.alexandria.restaccessor.core.RestAccessorNotifier;
import io.intino.monet.box.schemas.Order;
import java.io.File;
import java.net.URL;

public class OrdersApiAccessor {
    private final URL url;
    private final RestAccessorNotifier notifier = new RestAccessorNotifier();
    private int timeoutMillis = 120000;
    private OutBox outBox = null;

    public OrdersApiAccessor(URL url) {
        this.url = url;
    }

    public OrdersApiAccessor(URL url, int timeoutMillis) {
        this.url = url;
        this.timeoutMillis = timeoutMillis;
    }

    public OrdersApiAccessor(URL url, int timeoutMillis, File outBoxDirectory, int intervalRetrySeconds) {
        this.url = url;
        this.timeoutMillis = timeoutMillis;
        this.outBox = new OutBox(outBoxDirectory, intervalRetrySeconds);
    }

    public Order getOrder(String orderId) throws Conflict, BadRequest, InternalServerError {
        RequestBuilder.Request request = new RequestBuilder(this.url).timeOut(this.timeoutMillis).build(RequestBuilder.Method.GET, "/api/orders/v1/order/" + orderId);
        try {
            Response response = request.execute();
            return (Order)ResponseAdapter.adapt((String)response.content(), Order.class);
        }
        catch (AlexandriaException e) {
            if (e instanceof Conflict) {
                throw (Conflict)e;
            }
            if (e instanceof BadRequest) {
                throw (BadRequest)e;
            }
            if (this.outBox != null) {
                this.outBox.push(request);
            }
            throw new InternalServerError(e.message());
        }
    }

    public Order postOrder(String orderId, String code, String input, String properties) throws Conflict, BadRequest, InternalServerError {
        RequestBuilder.Request request = new RequestBuilder(this.url).timeOut(this.timeoutMillis).queryParameter("code", (Object)code).queryParameter("input", (Object)input).queryParameter("properties", (Object)properties).build(RequestBuilder.Method.POST, "/api/orders/v1/order/" + orderId);
        try {
            Response response = request.execute();
            return (Order)ResponseAdapter.adapt((String)response.content(), Order.class);
        }
        catch (AlexandriaException e) {
            if (e instanceof Conflict) {
                throw (Conflict)e;
            }
            if (e instanceof BadRequest) {
                throw (BadRequest)e;
            }
            if (this.outBox != null) {
                this.outBox.push(request);
            }
            throw new InternalServerError(e.message());
        }
    }

    public Boolean deleteOrder(String orderId) throws Conflict, InternalServerError {
        RequestBuilder.Request request = new RequestBuilder(this.url).timeOut(this.timeoutMillis).build(RequestBuilder.Method.DELETE, "/api/orders/v1/order/" + orderId);
        try {
            Response response = request.execute();
            return (Boolean)ResponseAdapter.adapt((String)response.content(), Boolean.class);
        }
        catch (AlexandriaException e) {
            if (e instanceof Conflict) {
                throw (Conflict)e;
            }
            if (this.outBox != null) {
                this.outBox.push(request);
            }
            throw new InternalServerError(e.message());
        }
    }
}

