package io.intino.monet.box;

import java.util.List;
import java.util.ArrayList;
import java.util.Arrays;
import java.net.URL;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.restaccessor.RequestBuilder;
import io.intino.alexandria.restaccessor.core.RestAccessorNotifier;
import io.intino.alexandria.restaccessor.exceptions.RestfulFailure;

import io.intino.monet.box.schemas.*;

public class OrdersApiAccessor {
	private final URL url;
	private final RestAccessorNotifier notifier = new RestAccessorNotifier();
	private int timeoutMillis = 120 * 1_000;
	private io.intino.alexandria.restaccessor.OutBox outBox = null;



	public OrdersApiAccessor(URL url) {
		this.url = url;

	}

	public OrdersApiAccessor(URL url, int timeoutMillis) {
		this.url = url;
		this.timeoutMillis = timeoutMillis;

	}

	public OrdersApiAccessor(URL url, int timeoutMillis, java.io.File outBoxDirectory, int intervalRetrySeconds) {
		this.url = url;
		this.timeoutMillis = timeoutMillis;
		this.outBox = new io.intino.alexandria.restaccessor.OutBox(outBoxDirectory, intervalRetrySeconds);

	}

	public Order getOrder(String orderId) throws Conflict, BadRequest, InternalServerError {
		RequestBuilder.Request request = new RequestBuilder(this.url).timeOut(this.timeoutMillis)
			.build(RequestBuilder.Method.GET, "/api" + "/orders" + "/v1" + "/order" + "/" + orderId);
		try {
			io.intino.alexandria.restaccessor.Response response = request.execute();
			return io.intino.alexandria.restaccessor.adapters.ResponseAdapter.adapt(response.content(), Order.class);
		} catch (AlexandriaException e) {
			if (e instanceof Conflict) throw ((Conflict) e);
			else if (e instanceof BadRequest) throw ((BadRequest) e);
			if (outBox != null) outBox.push(request);
			throw new InternalServerError(e.message());
		}
	}

	public Order postOrder(String orderId, String code, String input, String properties) throws Conflict, BadRequest, InternalServerError {
		RequestBuilder.Request request = new RequestBuilder(this.url).timeOut(this.timeoutMillis)
			.queryParameter("code", code)
			.queryParameter("input", input)
			.queryParameter("properties", properties)
			.build(RequestBuilder.Method.POST, "/api" + "/orders" + "/v1" + "/order" + "/" + orderId);
		try {
			io.intino.alexandria.restaccessor.Response response = request.execute();
			return io.intino.alexandria.restaccessor.adapters.ResponseAdapter.adapt(response.content(), Order.class);
		} catch (AlexandriaException e) {
			if (e instanceof Conflict) throw ((Conflict) e);
			else if (e instanceof BadRequest) throw ((BadRequest) e);
			if (outBox != null) outBox.push(request);
			throw new InternalServerError(e.message());
		}
	}

	public Boolean deleteOrder(String orderId) throws Conflict, InternalServerError {
		RequestBuilder.Request request = new RequestBuilder(this.url).timeOut(this.timeoutMillis)
			.build(RequestBuilder.Method.DELETE, "/api" + "/orders" + "/v1" + "/order" + "/" + orderId);
		try {
			io.intino.alexandria.restaccessor.Response response = request.execute();
			return io.intino.alexandria.restaccessor.adapters.ResponseAdapter.adapt(response.content(), Boolean.class);
		} catch (AlexandriaException e) {
			if (e instanceof Conflict) throw ((Conflict) e);
			if (outBox != null) outBox.push(request);
			throw new InternalServerError(e.message());
		}
	}


}